/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.fetcher;

import edu.uci.ics.crawler4j.crawler.Page;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageFetchResult {
    protected static final Logger logger = LoggerFactory.getLogger(PageFetchResult.class);
    private boolean haltOnError;
    protected int statusCode;
    protected HttpEntity entity = null;
    protected Header[] responseHeaders = null;
    protected String fetchedUrl = null;
    protected String movedToUrl = null;

    public PageFetchResult(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public Header[] getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Header[] responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public String getFetchedUrl() {
        return this.fetchedUrl;
    }

    public void setFetchedUrl(String fetchedUrl) {
        this.fetchedUrl = fetchedUrl;
    }

    public boolean fetchContent(Page page, int maxBytes) throws SocketTimeoutException, IOException {
        try {
            page.setFetchResponseHeaders(this.responseHeaders);
            page.load(this.entity, maxBytes);
            return true;
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            if (this.haltOnError) {
                throw e;
            }
            logger.info("Exception while fetching content for: {} [{}]", (Object)page.getWebURL().getURL(), (Object)e.getMessage());
            return false;
        }
    }

    public void discardContentIfNotConsumed() {
        try {
            if (this.entity != null) {
                EntityUtils.consume((HttpEntity)this.entity);
            }
        }
        catch (IOException iOException) {
        }
        catch (RuntimeException e) {
            if (this.haltOnError) {
                throw e;
            }
            logger.warn("Unexpected error occurred while trying to discard content", (Throwable)e);
        }
    }

    public String getMovedToUrl() {
        return this.movedToUrl;
    }

    public void setMovedToUrl(String movedToUrl) {
        this.movedToUrl = movedToUrl;
    }
}

