/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.crawler;

import edu.uci.ics.crawler4j.crawler.authentication.AuthInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.CookieStore;
import org.apache.http.conn.DnsResolver;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.message.BasicHeader;

public class CrawlConfig {
    private String crawlStorageFolder;
    private boolean resumableCrawling = false;
    private long dbLockTimeout = 500L;
    private int maxDepthOfCrawling = -1;
    private int maxPagesToFetch = -1;
    private String userAgentString = "crawler4j (https://github.com/yasserg/crawler4j/)";
    private Collection<BasicHeader> defaultHeaders = new HashSet<BasicHeader>();
    private int politenessDelay = 200;
    private boolean includeHttpsPages = true;
    private boolean includeBinaryContentInCrawling = false;
    private boolean processBinaryContentInCrawling = false;
    private int maxConnectionsPerHost = 100;
    private int maxTotalConnections = 100;
    private int socketTimeout = 20000;
    private int connectionTimeout = 30000;
    private int maxOutgoingLinksToFollow = 5000;
    private int maxDownloadSize = 0x100000;
    private boolean followRedirects = true;
    private boolean onlineTldListUpdate = false;
    private String publicSuffixSourceUrl = "https://publicsuffix.org/list/public_suffix_list.dat";
    private String publicSuffixLocalFile = null;
    private boolean shutdownOnEmptyQueue = true;
    private int threadMonitoringDelaySeconds = 10;
    private int threadShutdownDelaySeconds = 10;
    private int cleanupDelaySeconds = 10;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private List<AuthInfo> authInfos;
    private String cookiePolicy = "standard";
    private boolean respectNoFollow = true;
    private boolean respectNoIndex = true;
    private CookieStore cookieStore;
    private DnsResolver dnsResolver = new SystemDefaultDnsResolver();
    private boolean haltOnError = false;
    private boolean allowSingleLevelDomain = false;
    private int batchReadSize = 50;

    public void setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    public DnsResolver getDnsResolver() {
        return this.dnsResolver;
    }

    public void validate() throws Exception {
        if (this.crawlStorageFolder == null) {
            throw new Exception("Crawl storage folder is not set in the CrawlConfig.");
        }
        if (this.politenessDelay < 0) {
            throw new Exception("Invalid value for politeness delay: " + this.politenessDelay);
        }
        if (this.maxDepthOfCrawling < -1) {
            throw new Exception("Maximum crawl depth should be either a positive number or -1 for unlimited depth.");
        }
        if (this.maxDepthOfCrawling > Short.MAX_VALUE) {
            throw new Exception("Maximum value for crawl depth is 32767");
        }
    }

    public String getCrawlStorageFolder() {
        return this.crawlStorageFolder;
    }

    public void setCrawlStorageFolder(String crawlStorageFolder) {
        this.crawlStorageFolder = crawlStorageFolder;
    }

    public boolean isResumableCrawling() {
        return this.resumableCrawling;
    }

    public void setResumableCrawling(boolean resumableCrawling) {
        this.resumableCrawling = resumableCrawling;
    }

    public void setDbLockTimeout(long dbLockTimeout) {
        this.dbLockTimeout = dbLockTimeout;
    }

    public long getDbLockTimeout() {
        return this.dbLockTimeout;
    }

    public int getMaxDepthOfCrawling() {
        return this.maxDepthOfCrawling;
    }

    public void setMaxDepthOfCrawling(int maxDepthOfCrawling) {
        this.maxDepthOfCrawling = maxDepthOfCrawling;
    }

    public int getMaxPagesToFetch() {
        return this.maxPagesToFetch;
    }

    public void setMaxPagesToFetch(int maxPagesToFetch) {
        this.maxPagesToFetch = maxPagesToFetch;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public Collection<BasicHeader> getDefaultHeaders() {
        return new HashSet<BasicHeader>(this.defaultHeaders);
    }

    public void setDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        HashSet<BasicHeader> copiedHeaders = new HashSet<BasicHeader>();
        for (Header header : defaultHeaders) {
            copiedHeaders.add(new BasicHeader(header.getName(), header.getValue()));
        }
        this.defaultHeaders = copiedHeaders;
    }

    public int getPolitenessDelay() {
        return this.politenessDelay;
    }

    public void setPolitenessDelay(int politenessDelay) {
        this.politenessDelay = politenessDelay;
    }

    public boolean isIncludeHttpsPages() {
        return this.includeHttpsPages;
    }

    public void setIncludeHttpsPages(boolean includeHttpsPages) {
        this.includeHttpsPages = includeHttpsPages;
    }

    public boolean isIncludeBinaryContentInCrawling() {
        return this.includeBinaryContentInCrawling;
    }

    public void setIncludeBinaryContentInCrawling(boolean includeBinaryContentInCrawling) {
        this.includeBinaryContentInCrawling = includeBinaryContentInCrawling;
    }

    public boolean isProcessBinaryContentInCrawling() {
        return this.processBinaryContentInCrawling;
    }

    public void setProcessBinaryContentInCrawling(boolean processBinaryContentInCrawling) {
        this.processBinaryContentInCrawling = processBinaryContentInCrawling;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxOutgoingLinksToFollow() {
        return this.maxOutgoingLinksToFollow;
    }

    public void setMaxOutgoingLinksToFollow(int maxOutgoingLinksToFollow) {
        this.maxOutgoingLinksToFollow = maxOutgoingLinksToFollow;
    }

    public int getMaxDownloadSize() {
        return this.maxDownloadSize;
    }

    public void setMaxDownloadSize(int maxDownloadSize) {
        this.maxDownloadSize = maxDownloadSize;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isShutdownOnEmptyQueue() {
        return this.shutdownOnEmptyQueue;
    }

    public void setShutdownOnEmptyQueue(boolean shutdown) {
        this.shutdownOnEmptyQueue = shutdown;
    }

    public boolean isOnlineTldListUpdate() {
        return this.onlineTldListUpdate;
    }

    public void setOnlineTldListUpdate(boolean online) {
        this.onlineTldListUpdate = online;
    }

    public String getPublicSuffixSourceUrl() {
        return this.publicSuffixSourceUrl;
    }

    public void setPublicSuffixSourceUrl(String publicSuffixSourceUrl) {
        this.publicSuffixSourceUrl = publicSuffixSourceUrl;
    }

    public String getPublicSuffixLocalFile() {
        return this.publicSuffixLocalFile;
    }

    public void setPublicSuffixLocalFile(String publicSuffixLocalFile) {
        this.publicSuffixLocalFile = publicSuffixLocalFile;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public List<AuthInfo> getAuthInfos() {
        return this.authInfos;
    }

    public void addAuthInfo(AuthInfo authInfo) {
        if (this.authInfos == null) {
            this.authInfos = new ArrayList<AuthInfo>();
        }
        this.authInfos.add(authInfo);
    }

    public void setAuthInfos(List<AuthInfo> authInfos) {
        this.authInfos = authInfos;
    }

    public int getThreadMonitoringDelaySeconds() {
        return this.threadMonitoringDelaySeconds;
    }

    public void setThreadMonitoringDelaySeconds(int delay) {
        this.threadMonitoringDelaySeconds = delay;
    }

    public int getThreadShutdownDelaySeconds() {
        return this.threadShutdownDelaySeconds;
    }

    public void setThreadShutdownDelaySeconds(int delay) {
        this.threadShutdownDelaySeconds = delay;
    }

    public int getCleanupDelaySeconds() {
        return this.cleanupDelaySeconds;
    }

    public void setCleanupDelaySeconds(int delay) {
        this.cleanupDelaySeconds = delay;
    }

    public String getCookiePolicy() {
        return this.cookiePolicy;
    }

    public void setCookiePolicy(String cookiePolicy) {
        this.cookiePolicy = cookiePolicy;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public boolean isRespectNoFollow() {
        return this.respectNoFollow;
    }

    public void setRespectNoFollow(boolean respectNoFollow) {
        this.respectNoFollow = respectNoFollow;
    }

    public boolean isRespectNoIndex() {
        return this.respectNoIndex;
    }

    public void setRespectNoIndex(boolean respectNoIndex) {
        this.respectNoIndex = respectNoIndex;
    }

    public boolean isHaltOnError() {
        return this.haltOnError;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public boolean isAllowSingleLevelDomain() {
        return this.allowSingleLevelDomain;
    }

    public void setAllowSingleLevelDomain(boolean allowSingleLevelDomain) {
        this.allowSingleLevelDomain = allowSingleLevelDomain;
    }

    public int getBatchReadSize() {
        return this.batchReadSize;
    }

    public void setBatchReadSize(int batchReadSize) {
        this.batchReadSize = batchReadSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Crawl storage folder: " + this.getCrawlStorageFolder() + "\n");
        sb.append("Resumable crawling: " + this.isResumableCrawling() + "\n");
        sb.append("Max depth of crawl: " + this.getMaxDepthOfCrawling() + "\n");
        sb.append("Max pages to fetch: " + this.getMaxPagesToFetch() + "\n");
        sb.append("User agent string: " + this.getUserAgentString() + "\n");
        sb.append("Include https pages: " + this.isIncludeHttpsPages() + "\n");
        sb.append("Include binary content: " + this.isIncludeBinaryContentInCrawling() + "\n");
        sb.append("Max connections per host: " + this.getMaxConnectionsPerHost() + "\n");
        sb.append("Max total connections: " + this.getMaxTotalConnections() + "\n");
        sb.append("Socket timeout: " + this.getSocketTimeout() + "\n");
        sb.append("Max total connections: " + this.getMaxTotalConnections() + "\n");
        sb.append("Max outgoing links to follow: " + this.getMaxOutgoingLinksToFollow() + "\n");
        sb.append("Max download size: " + this.getMaxDownloadSize() + "\n");
        sb.append("Should follow redirects?: " + this.isFollowRedirects() + "\n");
        sb.append("Proxy host: " + this.getProxyHost() + "\n");
        sb.append("Proxy port: " + this.getProxyPort() + "\n");
        sb.append("Proxy username: " + this.getProxyUsername() + "\n");
        sb.append("Thread monitoring delay: " + this.getThreadMonitoringDelaySeconds() + "\n");
        sb.append("Thread shutdown delay: " + this.getThreadShutdownDelaySeconds() + "\n");
        sb.append("Cleanup delay: " + this.getCleanupDelaySeconds() + "\n");
        sb.append("Cookie policy: " + this.getCookiePolicy() + "\n");
        sb.append("Respect nofollow: " + this.isRespectNoFollow() + "\n");
        sb.append("Respect noindex: " + this.isRespectNoIndex() + "\n");
        sb.append("Halt on error: " + this.isHaltOnError() + "\n");
        sb.append("Allow single level domain:" + this.isAllowSingleLevelDomain() + "\n");
        sb.append("Batch read size: " + this.getBatchReadSize() + "\n");
        return sb.toString();
    }
}

