/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.url;

public final class UrlResolver {
    public static String resolveUrl(String baseUrl, String relativeUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null");
        }
        if (relativeUrl == null) {
            throw new IllegalArgumentException("Relative URL must not be null");
        }
        Url url = UrlResolver.resolveUrl(UrlResolver.parseUrl(baseUrl.trim()), relativeUrl.trim());
        return url.toString();
    }

    private static int indexOf(String s, char searchChar, int beginIndex, int endIndex) {
        for (int i = beginIndex; i < endIndex; ++i) {
            if (s.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    private static Url parseUrl(String spec) {
        int semicolonIndex;
        int questionMarkIndex;
        int locationEndIndex;
        int locationStartIndex;
        String scheme;
        int colonIndex;
        Url url = new Url();
        int startIndex = 0;
        int endIndex = spec.length();
        int crosshatchIndex = UrlResolver.indexOf(spec, '#', startIndex, endIndex);
        if (crosshatchIndex >= 0) {
            url.fragment_ = spec.substring(crosshatchIndex + 1, endIndex);
            endIndex = crosshatchIndex;
        }
        if ((colonIndex = UrlResolver.indexOf(spec, ':', startIndex, endIndex)) > 0 && UrlResolver.isValidScheme(scheme = spec.substring(startIndex, colonIndex))) {
            url.scheme_ = scheme;
            startIndex = colonIndex + 1;
        }
        if (spec.startsWith("//", startIndex)) {
            locationStartIndex = startIndex + 2;
            locationEndIndex = UrlResolver.indexOf(spec, '/', locationStartIndex, endIndex);
            if (locationEndIndex >= 0) {
                startIndex = locationEndIndex;
            }
        } else {
            locationStartIndex = -1;
            locationEndIndex = -1;
        }
        if ((questionMarkIndex = UrlResolver.indexOf(spec, '?', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = questionMarkIndex;
                startIndex = questionMarkIndex;
            }
            url.query_ = spec.substring(questionMarkIndex + 1, endIndex);
            endIndex = questionMarkIndex;
        }
        if ((semicolonIndex = UrlResolver.indexOf(spec, ';', startIndex, endIndex)) >= 0) {
            if (locationStartIndex >= 0 && locationEndIndex < 0) {
                locationEndIndex = semicolonIndex;
                startIndex = semicolonIndex;
            }
            url.parameters_ = spec.substring(semicolonIndex + 1, endIndex);
            endIndex = semicolonIndex;
        }
        if (locationStartIndex >= 0 && locationEndIndex < 0) {
            locationEndIndex = endIndex;
        } else if (startIndex < endIndex) {
            url.path_ = spec.substring(startIndex, endIndex);
        }
        if (locationStartIndex >= 0 && locationEndIndex >= 0) {
            url.location_ = spec.substring(locationStartIndex, locationEndIndex);
        }
        return url;
    }

    private static boolean isValidScheme(String scheme) {
        int length = scheme.length();
        if (length < 1) {
            return false;
        }
        char c = scheme.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = scheme.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static Url resolveUrl(Url baseUrl, String relativeUrl) {
        int slashIndex;
        String pathSegment;
        int pathSegmentIndex;
        Url url = UrlResolver.parseUrl(relativeUrl);
        if (baseUrl == null) {
            return url;
        }
        if (relativeUrl.isEmpty()) {
            return new Url(baseUrl);
        }
        if (url.scheme_ != null) {
            return url;
        }
        url.scheme_ = baseUrl.scheme_;
        if (url.location_ != null) {
            return url;
        }
        url.location_ = baseUrl.location_;
        if (url.path_ != null && !url.path_.isEmpty() && url.path_.charAt(0) == '/') {
            url.path_ = UrlResolver.removeLeadingSlashPoints(url.path_);
            return url;
        }
        if (url.path_ == null) {
            url.path_ = baseUrl.path_;
            if (url.parameters_ != null) {
                return url;
            }
            url.parameters_ = baseUrl.parameters_;
            if (url.query_ != null) {
                return url;
            }
            url.query_ = baseUrl.query_;
            return url;
        }
        String basePath = baseUrl.path_;
        String path = "";
        if (basePath != null) {
            int lastSlashIndex = basePath.lastIndexOf(47);
            if (lastSlashIndex >= 0) {
                path = basePath.substring(0, lastSlashIndex + 1);
            }
        } else {
            path = "/";
        }
        path = path.concat(url.path_);
        while ((pathSegmentIndex = path.indexOf("/./")) >= 0) {
            path = path.substring(0, pathSegmentIndex + 1).concat(path.substring(pathSegmentIndex + 3));
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        while ((pathSegmentIndex = path.indexOf("/../")) > 0) {
            pathSegment = path.substring(0, pathSegmentIndex);
            slashIndex = pathSegment.lastIndexOf(47);
            if (slashIndex < 0 || "..".equals(pathSegment.substring(slashIndex))) continue;
            path = path.substring(0, slashIndex + 1).concat(path.substring(pathSegmentIndex + 4));
        }
        if (path.endsWith("/..") && (slashIndex = (pathSegment = path.substring(0, path.length() - 3)).lastIndexOf(47)) >= 0) {
            path = path.substring(0, slashIndex + 1);
        }
        url.path_ = path = UrlResolver.removeLeadingSlashPoints(path);
        return url;
    }

    private static String removeLeadingSlashPoints(String path) {
        while (path.startsWith("/..")) {
            path = path.substring(3);
        }
        return path;
    }

    private static class Url {
        String scheme_;
        String location_;
        String path_;
        String parameters_;
        String query_;
        String fragment_;

        public Url() {
        }

        public Url(Url url) {
            this.scheme_ = url.scheme_;
            this.location_ = url.location_;
            this.path_ = url.path_;
            this.parameters_ = url.parameters_;
            this.query_ = url.query_;
            this.fragment_ = url.fragment_;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.scheme_ != null) {
                sb.append(this.scheme_);
                sb.append(':');
            }
            if (this.location_ != null) {
                sb.append("//");
                sb.append(this.location_);
            }
            if (this.path_ != null) {
                sb.append(this.path_);
            }
            if (this.parameters_ != null) {
                sb.append(';');
                sb.append(this.parameters_);
            }
            if (this.query_ != null) {
                sb.append('?');
                sb.append(this.query_);
            }
            if (this.fragment_ != null) {
                sb.append('#');
                sb.append(this.fragment_);
            }
            return sb.toString();
        }
    }
}

