/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.robotstxt;

import edu.uci.ics.crawler4j.robotstxt.RuleSet;

public class HostDirectives {
    private static final long EXPIRATION_DELAY = 1440000L;
    private final RuleSet disallows = new RuleSet();
    private final RuleSet allows = new RuleSet();
    private final long timeFetched = System.currentTimeMillis();
    private long timeLastAccessed;

    public boolean needsRefetch() {
        return System.currentTimeMillis() - this.timeFetched > 1440000L;
    }

    public boolean allows(String path) {
        this.timeLastAccessed = System.currentTimeMillis();
        return !this.disallows.containsPrefixOf(path) || this.allows.containsPrefixOf(path);
    }

    public void addDisallow(String path) {
        this.disallows.add(path);
    }

    public void addAllow(String path) {
        this.allows.add(path);
    }

    public long getLastAccessTime() {
        return this.timeLastAccessed;
    }
}

