/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.frontier;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import edu.uci.ics.crawler4j.crawler.Configurable;
import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.frontier.Counters;
import edu.uci.ics.crawler4j.frontier.InProcessPagesDB;
import edu.uci.ics.crawler4j.frontier.WorkQueues;
import edu.uci.ics.crawler4j.url.WebURL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frontier
extends Configurable {
    protected static final Logger logger = LoggerFactory.getLogger(Frontier.class);
    private static final String DATABASE_NAME = "PendingURLsDB";
    private static final int IN_PROCESS_RESCHEDULE_BATCH_SIZE = 100;
    protected WorkQueues workQueues;
    protected InProcessPagesDB inProcessPages;
    protected final Object mutex = new Object();
    protected final Object waitingList = new Object();
    protected boolean isFinished = false;
    protected long scheduledPages;
    protected Counters counters;

    public Frontier(Environment env, CrawlConfig config) {
        super(config);
        this.counters = new Counters(env, config);
        try {
            this.workQueues = new WorkQueues(env, DATABASE_NAME, config.isResumableCrawling());
            if (config.isResumableCrawling()) {
                this.scheduledPages = this.counters.getValue("Scheduled-Pages");
                this.inProcessPages = new InProcessPagesDB(env);
                long numPreviouslyInProcessPages = this.inProcessPages.getLength();
                if (numPreviouslyInProcessPages > 0L) {
                    logger.info("Rescheduling {} URLs from previous crawl.", (Object)numPreviouslyInProcessPages);
                    this.scheduledPages -= numPreviouslyInProcessPages;
                    List<WebURL> urls = this.inProcessPages.get(100);
                    while (!urls.isEmpty()) {
                        this.scheduleAll(urls);
                        this.inProcessPages.delete(urls.size());
                        urls = this.inProcessPages.get(100);
                    }
                }
            } else {
                this.inProcessPages = null;
                this.scheduledPages = 0L;
            }
        }
        catch (DatabaseException e) {
            logger.error("Error while initializing the Frontier", (Throwable)e);
            this.workQueues = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAll(List<WebURL> urls) {
        int maxPagesToFetch = this.config.getMaxPagesToFetch();
        Object object = this.mutex;
        synchronized (object) {
            int newScheduledPage = 0;
            for (WebURL url : urls) {
                if (maxPagesToFetch > 0 && this.scheduledPages + (long)newScheduledPage >= (long)maxPagesToFetch) break;
                try {
                    this.workQueues.put(url);
                    ++newScheduledPage;
                }
                catch (DatabaseException e) {
                    logger.error("Error while putting the url in the work queue", (Throwable)e);
                }
            }
            if (newScheduledPage > 0) {
                this.scheduledPages += (long)newScheduledPage;
                this.counters.increment("Scheduled-Pages", newScheduledPage);
            }
            Object object2 = this.waitingList;
            synchronized (object2) {
                this.waitingList.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(WebURL url) {
        int maxPagesToFetch = this.config.getMaxPagesToFetch();
        Object object = this.mutex;
        synchronized (object) {
            try {
                if (maxPagesToFetch < 0 || this.scheduledPages < (long)maxPagesToFetch) {
                    this.workQueues.put(url);
                    ++this.scheduledPages;
                    this.counters.increment("Scheduled-Pages");
                }
            }
            catch (DatabaseException e) {
                logger.error("Error while putting the url in the work queue", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNextURLs(int max, List<WebURL> result) {
        do {
            Object object = this.mutex;
            synchronized (object) {
                if (this.isFinished) {
                    return;
                }
                try {
                    List<WebURL> curResults = this.workQueues.get(max);
                    this.workQueues.delete(curResults.size());
                    if (this.inProcessPages != null) {
                        for (WebURL curPage : curResults) {
                            this.inProcessPages.put(curPage);
                        }
                    }
                    result.addAll(curResults);
                }
                catch (DatabaseException e) {
                    logger.error("Error while getting next urls", (Throwable)e);
                }
                if (result.size() > 0) {
                    return;
                }
            }
            try {
                object = this.waitingList;
                synchronized (object) {
                    this.waitingList.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.isFinished);
    }

    public void setProcessed(WebURL webURL) {
        this.counters.increment("Processed-Pages");
        if (this.inProcessPages != null && !this.inProcessPages.removeURL(webURL)) {
            logger.warn("Could not remove: {} from list of processed pages.", (Object)webURL.getURL());
        }
    }

    public long getQueueLength() {
        return this.workQueues.getLength();
    }

    public long getNumberOfAssignedPages() {
        return this.inProcessPages.getLength();
    }

    public long getNumberOfProcessedPages() {
        return this.counters.getValue("Processed-Pages");
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void close() {
        this.workQueues.close();
        this.counters.close();
        if (this.inProcessPages != null) {
            this.inProcessPages.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.isFinished = true;
        Object object = this.waitingList;
        synchronized (object) {
            this.waitingList.notifyAll();
        }
    }
}

