/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.crawler;

import edu.uci.ics.crawler4j.parser.ParseData;
import edu.uci.ics.crawler4j.url.WebURL;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class Page {
    protected WebURL url;
    protected boolean redirect;
    protected String redirectedToUrl;
    protected int statusCode;
    protected byte[] contentData;
    protected String contentType;
    protected String contentEncoding;
    protected String contentCharset;
    private String language;
    protected Header[] fetchResponseHeaders;
    protected ParseData parseData;

    public Page(WebURL url) {
        this.url = url;
    }

    public void load(HttpEntity entity) throws Exception {
        Charset charset;
        this.contentType = null;
        Header type = entity.getContentType();
        if (type != null) {
            this.contentType = type.getValue();
        }
        this.contentEncoding = null;
        Header encoding = entity.getContentEncoding();
        if (encoding != null) {
            this.contentEncoding = encoding.getValue();
        }
        if ((charset = ContentType.getOrDefault((HttpEntity)entity).getCharset()) != null) {
            this.contentCharset = charset.displayName();
        }
        this.contentData = EntityUtils.toByteArray((HttpEntity)entity);
    }

    public WebURL getWebURL() {
        return this.url;
    }

    public void setWebURL(WebURL url) {
        this.url = url;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public String getRedirectedToUrl() {
        return this.redirectedToUrl;
    }

    public void setRedirectedToUrl(String redirectedToUrl) {
        this.redirectedToUrl = redirectedToUrl;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public Header[] getFetchResponseHeaders() {
        return this.fetchResponseHeaders;
    }

    public void setFetchResponseHeaders(Header[] headers) {
        this.fetchResponseHeaders = headers;
    }

    public ParseData getParseData() {
        return this.parseData;
    }

    public void setParseData(ParseData parseData) {
        this.parseData = parseData;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public void setContentData(byte[] contentData) {
        this.contentData = contentData;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public void setContentCharset(String contentCharset) {
        this.contentCharset = contentCharset;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

