/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.parse;

import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.data.parse.SenseKeyParser;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.SenseEntry;

public class SenseLineParser
implements ILineParser<ISenseEntry> {
    private static SenseLineParser instance;
    protected final ILineParser<ISenseKey> keyParser;

    public static SenseLineParser getInstance() {
        if (instance == null) {
            instance = new SenseLineParser();
        }
        return instance;
    }

    protected SenseLineParser() {
        this(SenseKeyParser.getInstance());
    }

    protected SenseLineParser(ILineParser<ISenseKey> keyParser) {
        if (keyParser == null) {
            throw new NullPointerException();
        }
        this.keyParser = keyParser;
    }

    @Override
    public ISenseEntry parseLine(String line) {
        if (line == null) {
            throw new NullPointerException();
        }
        try {
            int begin = 0;
            int end = 0;
            end = line.indexOf(32, begin);
            String keyStr = line.substring(begin, end);
            ISenseKey sense_key = this.keyParser.parseLine(keyStr);
            begin = end + 1;
            end = line.indexOf(32, begin);
            int synset_offset = Integer.parseInt(line.substring(begin, end));
            begin = end + 1;
            end = line.indexOf(32, begin);
            int sense_number = Integer.parseInt(line.substring(begin, end));
            begin = end + 1;
            int tag_cnt = Integer.parseInt(line.substring(begin));
            return new SenseEntry(sense_key, synset_offset, sense_number, tag_cnt);
        }
        catch (Exception e) {
            throw new ILineParser.MisformattedLineException(line, e);
        }
    }
}

