/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;

public class RecoveredField
extends RecoveredElement {
    public FieldDeclaration fieldDeclaration;
    boolean alreadyCompletedFieldInitialization;
    public RecoveredType[] anonymousTypes;
    public int anonymousTypeCount;

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement parent, int bracketBalance) {
        this(fieldDeclaration, parent, bracketBalance, null);
    }

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement parent, int bracketBalance, Parser parser) {
        super(parent, bracketBalance, parser);
        this.fieldDeclaration = fieldDeclaration;
        this.alreadyCompletedFieldInitialization = fieldDeclaration.initialization != null;
    }

    public RecoveredElement add(Statement statement, int bracketBalanceValue) {
        if (this.alreadyCompletedFieldInitialization || !(statement instanceof Expression)) {
            return super.add(statement, bracketBalanceValue);
        }
        this.alreadyCompletedFieldInitialization = true;
        this.fieldDeclaration.initialization = (Expression)statement;
        this.fieldDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.fieldDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalanceValue) {
        if (this.alreadyCompletedFieldInitialization || (typeDeclaration.bits & 0x200) == 0 || this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            return super.add(typeDeclaration, bracketBalanceValue);
        }
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new RecoveredType[5];
            this.anonymousTypeCount = 0;
        } else if (this.anonymousTypeCount == this.anonymousTypes.length) {
            this.anonymousTypes = new RecoveredType[2 * this.anonymousTypeCount];
            System.arraycopy(this.anonymousTypes, 0, this.anonymousTypes, 0, this.anonymousTypeCount);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.anonymousTypes[this.anonymousTypeCount++] = element;
        return element;
    }

    public ASTNode parseTree() {
        return this.fieldDeclaration;
    }

    public int sourceEnd() {
        return this.fieldDeclaration.declarationSourceEnd;
    }

    public String toString(int tab) {
        StringBuffer buffer = new StringBuffer(this.tabString(tab));
        buffer.append("Recovered field:\n");
        this.fieldDeclaration.print(tab + 1, buffer);
        if (this.anonymousTypes != null) {
            int i = 0;
            while (i < this.anonymousTypeCount) {
                buffer.append("\n");
                buffer.append(this.anonymousTypes[i].toString(tab + 1));
                ++i;
            }
        }
        return buffer.toString();
    }

    public FieldDeclaration updatedFieldDeclaration() {
        if (this.anonymousTypes != null) {
            if (this.fieldDeclaration.initialization == null) {
                int i = 0;
                while (i < this.anonymousTypeCount) {
                    RecoveredType recoveredType = this.anonymousTypes[i];
                    TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                    if (typeDeclaration.declarationSourceEnd == 0) {
                        typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    if (recoveredType.preserveContent) {
                        this.fieldDeclaration.initialization = recoveredType.updatedTypeDeclaration().allocation;
                    }
                    ++i;
                }
                if (this.anonymousTypeCount > 0) {
                    this.fieldDeclaration.bits |= 2;
                }
            } else if (this.fieldDeclaration.getKind() == 3) {
                int i = 0;
                while (i < this.anonymousTypeCount) {
                    RecoveredType recoveredType = this.anonymousTypes[i];
                    TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                    if (typeDeclaration.declarationSourceEnd == 0) {
                        typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    recoveredType.updatedTypeDeclaration();
                    ++i;
                }
            }
        }
        return this.fieldDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                if (this.fieldDeclaration.getKind() == 3) {
                    this.updateSourceEndIfNecessary(braceEnd - 1);
                    return this.parent;
                }
                this.alreadyCompletedFieldInitialization = true;
            }
            return this;
        }
        if (this.bracketBalance == 0) {
            this.alreadyCompletedFieldInitialization = true;
            this.updateSourceEndIfNecessary(braceEnd - 1);
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(braceStart, braceEnd);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.fieldDeclaration.declarationSourceEnd == 0 && (this.fieldDeclaration.type instanceof ArrayTypeReference || this.fieldDeclaration.type instanceof ArrayQualifiedTypeReference) && !this.alreadyCompletedFieldInitialization) {
            ++this.bracketBalance;
            return null;
        }
        if (this.fieldDeclaration.declarationSourceEnd == 0 && this.fieldDeclaration.getKind() == 3) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(braceStart - 1, braceEnd - 1);
        return this.parent.updateOnOpeningBrace(braceStart, braceEnd);
    }

    public void updateParseTree() {
        this.updatedFieldDeclaration();
    }

    public void updateSourceEndIfNecessary(int bodyStart, int bodyEnd) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            this.fieldDeclaration.declarationSourceEnd = bodyEnd;
            this.fieldDeclaration.declarationEnd = bodyEnd;
        }
    }
}

