/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.rules.Handle;
import javax.rules.InvalidHandleException;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.StatefulRuleSession;
import org.drools.DroolsException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.NoSuchFactObjectException;
import org.drools.jsr94.rules.AbstractRuleSessionImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.jsr94.rules.admin.RuleExecutionSetRepository;

public class StatefulRuleSessionImpl
extends AbstractRuleSessionImpl
implements StatefulRuleSession {
    StatefulRuleSessionImpl(String bindUri, Map properties) throws RuleExecutionSetNotFoundException {
        this.setProperties(properties);
        RuleExecutionSetRepository repository = RuleExecutionSetRepository.getInstance();
        RuleExecutionSetImpl ruleSet = (RuleExecutionSetImpl)repository.getRuleExecutionSet(bindUri);
        if (ruleSet == null) {
            throw new RuleExecutionSetNotFoundException("no execution set bound to: " + bindUri);
        }
        this.setRuleExecutionSet(ruleSet);
        this.initWorkingMemory();
    }

    public boolean containsObject(Handle objectHandle) {
        if (objectHandle instanceof FactHandle) {
            return this.getWorkingMemory().containsObject((FactHandle)objectHandle);
        }
        return false;
    }

    public Handle addObject(Object object) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        try {
            return (Handle)this.getWorkingMemory().assertObject(object);
        }
        catch (FactException e) {
            throw new InvalidRuleSessionException("cannot assert object", (Exception)((Object)e));
        }
    }

    public List addObjects(List objList) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        ArrayList<Handle> handles = new ArrayList<Handle>();
        Iterator objectIter = objList.iterator();
        while (objectIter.hasNext()) {
            handles.add(this.addObject(objectIter.next()));
        }
        return handles;
    }

    public void updateObject(Handle objectHandle, Object newObject) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (objectHandle instanceof FactHandle) {
            try {
                this.getWorkingMemory().modifyObject((FactHandle)objectHandle, newObject);
            }
            catch (FactException e) {
                throw new InvalidRuleSessionException("cannot update object", (Exception)((Object)e));
            }
        } else {
            throw new InvalidHandleException("invalid handle");
        }
    }

    public void removeObject(Handle handleObject) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (handleObject instanceof FactHandle) {
            try {
                this.getWorkingMemory().retractObject((FactHandle)handleObject);
            }
            catch (FactException e) {
                throw new InvalidRuleSessionException("cannot remove object", (Exception)((Object)e));
            }
        } else {
            throw new InvalidHandleException("invalid handle");
        }
    }

    public List getObjects() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        return this.getObjects(this.getRuleExecutionSet().getObjectFilter());
    }

    public List getObjects(ObjectFilter filter) throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        ArrayList objects = new ArrayList();
        objects.addAll(this.getWorkingMemory().getObjects());
        this.applyFilter(objects, filter);
        return objects;
    }

    public void executeRules() throws InvalidRuleSessionException {
        this.checkRuleSessionValidity();
        try {
            this.getWorkingMemory().fireAllRules();
        }
        catch (DroolsException e) {
            throw new InvalidRuleSessionException("cannot execute rules", (Exception)((Object)e));
        }
    }

    public Object getObject(Handle handle) throws InvalidRuleSessionException, InvalidHandleException {
        this.checkRuleSessionValidity();
        if (handle instanceof FactHandle) {
            try {
                return this.getWorkingMemory().getObject((FactHandle)handle);
            }
            catch (NoSuchFactObjectException e) {
                throw new InvalidHandleException("invalid handle", (Exception)((Object)e));
            }
        }
        throw new InvalidHandleException("invalid handle");
    }

    public List getHandles() {
        LinkedList handles = new LinkedList();
        Iterator i = this.getWorkingMemory().getFactHandles().iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof Handle)) continue;
            handles.add(object);
        }
        return handles;
    }
}

