/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.util.HashSet;
import org.drools.io.BaseAbstractHandler;
import org.drools.io.Handler;
import org.drools.io.RuleSetReader;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.smf.Configuration;
import org.drools.smf.DefaultConfiguration;
import org.drools.smf.FactoryException;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.SemanticModule;
import org.drools.spi.ImportEntry;
import org.drools.spi.ObjectType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ObjectTypeHandler
extends BaseAbstractHandler
implements Handler {
    ObjectTypeHandler(RuleSetReader ruleSetReader) {
        this.ruleSetReader = ruleSetReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Declaration.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.ruleSetReader.startConfiguration(localName, attrs);
        return null;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.ruleSetReader.endConfiguration();
        SemanticModule module = this.ruleSetReader.lookupSemanticModule(uri, localName);
        ObjectTypeFactory factory = module.getObjectTypeFactory(localName);
        try {
            Rule rule = (Rule)this.ruleSetReader.getParent(Rule.class);
            Declaration declaration = (Declaration)this.ruleSetReader.getParent(Declaration.class);
            ((DefaultConfiguration)config).setAttribute("identifier", declaration.getIdentifier());
            ObjectType objectType = factory.newObjectType(rule, this.ruleSetReader.getFactoryContext(), config);
            declaration.setObjectType(objectType);
        }
        catch (FactoryException e) {
            throw new SAXParseException("error constructing object type", this.ruleSetReader.getLocator(), (Exception)((Object)e));
        }
        return null;
    }

    public Class generateNodeFor() {
        return ImportEntry.class;
    }
}

