/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io;

import java.util.HashSet;
import org.drools.io.BaseAbstractHandler;
import org.drools.io.Handler;
import org.drools.io.RuleSetReader;
import org.drools.rule.ApplicationData;
import org.drools.rule.RuleSet;
import org.drools.smf.ApplicationDataFactory;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.smf.SemanticModule;
import org.drools.spi.ImportEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ApplicationDataHandler
extends BaseAbstractHandler
implements Handler {
    ApplicationDataHandler(RuleSetReader ruleSetReader) {
        this.ruleSetReader = ruleSetReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(RuleSet.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(ApplicationData.class);
            this.validPeers.add(ImportEntry.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.ruleSetReader.startConfiguration(localName, attrs);
        return null;
    }

    public Object end(String uri, String localName) throws SAXException {
        ApplicationData applicationData;
        SemanticModule module = this.ruleSetReader.lookupSemanticModule(uri, localName);
        ApplicationDataFactory factory = module.getApplicationDataFactory(localName);
        Configuration config = this.ruleSetReader.endConfiguration();
        try {
            applicationData = factory.newApplicationData(this.ruleSetReader.getRuleSet(), this.ruleSetReader.getFactoryContext(), config);
            this.ruleSetReader.getRuleSet().addApplicationData(applicationData);
        }
        catch (FactoryException e) {
            throw new SAXParseException("error constructing import", this.ruleSetReader.getLocator(), (Exception)((Object)e));
        }
        return applicationData;
    }

    public Class generateNodeFor() {
        return ApplicationData.class;
    }
}

