/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.NoSuchFactHandleException;
import org.drools.NoSuchFactObjectException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventSupport;
import org.drools.reteoo.Agenda;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.JoinMemory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AsyncExceptionHandler;
import org.drools.util.IdentityMap;
import org.drools.util.PrimitiveLongMap;
import org.drools.util.PrimitiveLongStack;

class WorkingMemoryImpl
implements WorkingMemory,
PropertyChangeListener {
    private static final Class[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    private final Object[] addRemovePropertyChangeListenerArgs = new Object[]{this};
    private final Map joinMemories = new HashMap();
    private final Map applicationData = new HashMap();
    private final PrimitiveLongMap objects = new PrimitiveLongMap(32, 8);
    private final Map handles = new IdentityMap();
    private final PrimitiveLongStack factHandlePool = new PrimitiveLongStack();
    private final WorkingMemoryEventSupport eventSupport = new WorkingMemoryEventSupport(this);
    private final RuleBaseImpl ruleBase;
    private final Agenda agenda;
    private boolean firing;

    public WorkingMemoryImpl(RuleBaseImpl ruleBase) {
        this.ruleBase = ruleBase;
        this.agenda = new Agenda(this, ruleBase.getConflictResolver());
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public List getEventListeners() {
        return this.eventSupport.getEventListeners();
    }

    FactHandle newFactHandle() {
        if (!this.factHandlePool.isEmpty()) {
            return this.ruleBase.getFactHandleFactory().newFactHandle(this.factHandlePool.pop());
        }
        return this.ruleBase.getFactHandleFactory().newFactHandle();
    }

    public Map getApplicationDataMap() {
        return this.applicationData;
    }

    public void setApplicationData(String name, Object value) {
        Map applicationDataDefintions = this.ruleBase.getApplicationData();
        Class type = (Class)applicationDataDefintions.get(name);
        if (type == null) {
            throw new RuntimeException("Unexpected application data [" + name + "]");
        }
        if (!type.isInstance(value)) {
            throw new RuntimeException("Illegal class for application data. Expected [" + type.getName() + "], " + "found [" + value.getClass().getName() + "].");
        }
        this.applicationData.put(name, value);
    }

    public Object getApplicationData(String name) {
        return this.applicationData.get(name);
    }

    protected Agenda getAgenda() {
        return this.agenda;
    }

    public void clearAgenda() {
        this.agenda.clearAgenda();
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAllRules(AgendaFilter agendaFilter) throws FactException {
        if (!this.firing) {
            try {
                this.firing = true;
                while (!this.agenda.isEmpty()) {
                    this.agenda.fireNextItem(agendaFilter);
                }
            }
            finally {
                this.firing = false;
            }
        }
    }

    public void fireAllRules() throws FactException {
        this.fireAllRules(null);
    }

    public Object getObject(FactHandle handle) throws NoSuchFactObjectException {
        Object object = this.objects.get(((FactHandleImpl)handle).getId());
        if (object == null) {
            throw new NoSuchFactObjectException(handle);
        }
        return object;
    }

    public FactHandle getFactHandle(Object object) throws NoSuchFactHandleException {
        FactHandle factHandle = (FactHandle)this.handles.get(object);
        if (factHandle == null) {
            throw new NoSuchFactHandleException(object);
        }
        return factHandle;
    }

    public List getFactHandles() {
        return new ArrayList(this.handles.values());
    }

    public List getObjects() {
        return new ArrayList(this.objects.values());
    }

    public List getObjects(Class objectClass) {
        LinkedList matching = new LinkedList();
        Iterator objIter = this.objects.values().iterator();
        while (objIter.hasNext()) {
            Object obj = objIter.next();
            if (!objectClass.isInstance(obj)) continue;
            matching.add(obj);
        }
        return matching;
    }

    public boolean containsObject(FactHandle handle) {
        return this.objects.containsKey(((FactHandleImpl)handle).getId());
    }

    public FactHandle assertObject(Object object) throws FactException {
        return this.assertObject(object, false);
    }

    public FactHandle assertObject(Object object, boolean dynamic) throws FactException {
        FactHandle handle = (FactHandle)this.handles.get(object);
        if (handle != null) {
            return handle;
        }
        handle = this.newFactHandle();
        this.putObject(handle, object);
        if (dynamic) {
            this.addPropertyChangeListener(object);
        }
        this.agenda.setMode(Agenda.ASSERT);
        this.ruleBase.assertObject(handle, object, this);
        this.eventSupport.fireObjectAsserted(handle, object);
        this.agenda.setMode(Agenda.NONE);
        return handle;
    }

    private void addPropertyChangeListener(Object object) {
        try {
            Method method = object.getClass().getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            method.invoke(object, this.addRemovePropertyChangeListenerArgs);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Warning: Method addPropertyChangeListener not found on the class " + object.getClass() + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (IllegalAccessException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object");
        }
        catch (InvocationTargetException e) {
            System.err.println("Warning: The addPropertyChangeListener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " addPropertyChangeListener method" + " so Drools will be unable to process JavaBean" + " PropertyChangeEvents on the asserted Object: " + e.getMessage());
        }
    }

    private void removePropertyChangeListener(FactHandle handle) throws NoSuchFactObjectException {
        Object object = null;
        try {
            object = this.getObject(handle);
            Method mehod = handle.getClass().getMethod("removePropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
            mehod.invoke((Object)handle, this.addRemovePropertyChangeListenerArgs);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " does not take" + " a simple PropertyChangeListener argument" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (IllegalAccessException e) {
            System.err.println("Warning: The removePropertyChangeListener method on the class " + object.getClass() + " is not public" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object");
        }
        catch (InvocationTargetException e) {
            System.err.println("Warning: The removePropertyChangeL istener method on the class " + object.getClass() + " threw an InvocationTargetException" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
        catch (SecurityException e) {
            System.err.println("Warning: The SecurityManager controlling the class " + object.getClass() + " did not allow the lookup of a" + " removePropertyChangeListener method" + " so Drools will be unable to stop processing JavaBean" + " PropertyChangeEvents on the retracted Object: " + e.getMessage());
        }
    }

    Object putObject(FactHandle handle, Object object) {
        Object oldValue = this.objects.put(((FactHandleImpl)handle).getId(), object);
        this.handles.put(object, handle);
        return oldValue;
    }

    Object removeObject(FactHandle handle) {
        Object object = this.objects.remove(((FactHandleImpl)handle).getId());
        this.handles.remove(object);
        return object;
    }

    public void retractObject(FactHandle handle) throws FactException {
        this.removePropertyChangeListener(handle);
        this.agenda.setMode(Agenda.RETRACT);
        this.ruleBase.retractObject(handle, this);
        Object oldObject = this.removeObject(handle);
        this.factHandlePool.push(((FactHandleImpl)handle).getId());
        this.eventSupport.fireObjectRetracted(handle, oldObject);
        this.agenda.setMode(Agenda.NONE);
        ((FactHandleImpl)handle).invalidate();
    }

    public void modifyObject(FactHandle handle, Object object) throws FactException {
        Object originalObject = this.removeObject(handle);
        if (originalObject == null) {
            throw new NoSuchFactObjectException(handle);
        }
        this.putObject(handle, object);
        this.agenda.setMode(Agenda.MODIFY);
        this.ruleBase.retractObject(handle, this);
        this.ruleBase.assertObject(handle, object, this);
        this.agenda.removeMarkedItemsFromAgenda();
        this.agenda.setMode(Agenda.NONE);
        this.eventSupport.fireObjectModified(handle, originalObject, object);
    }

    public JoinMemory getJoinMemory(JoinNode node) {
        JoinMemory memory = (JoinMemory)this.joinMemories.get(node);
        if (memory == null) {
            memory = new JoinMemory(node.getTupleDeclarations(), node.getCommonDeclarations());
            this.joinMemories.put(node, memory);
        }
        return memory;
    }

    public WorkingMemoryEventSupport getEventSupport() {
        return this.eventSupport;
    }

    public void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
        this.agenda.setAsyncExceptionHandler(handler);
    }

    public void dumpMemory() {
        Iterator it = this.joinMemories.keySet().iterator();
        while (it.hasNext()) {
            ((JoinMemory)this.joinMemories.get(it.next())).dump();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object object = event.getSource();
        try {
            this.modifyObject(this.getFactHandle(object), object);
        }
        catch (NoSuchFactHandleException e) {
        }
        catch (FactException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

