/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.reteoo.AgendaItem;
import org.drools.reteoo.TupleKey;
import org.drools.rule.Rule;

public class AgendaItemMap
implements Serializable {
    private final Map ruleMap = new HashMap();

    public void putAgendaItem(Rule rule, TupleKey tupleKey, AgendaItem item) {
        this.put(rule, tupleKey, item);
    }

    public AgendaItem removeAgendaItem(Rule rule, TupleKey tupleKey) {
        return (AgendaItem)this.remove(rule, tupleKey);
    }

    void put(Rule rule, TupleKey tupleKey, Object obj) {
        HashMap<TupleKey, Object> tupleMap = (HashMap<TupleKey, Object>)this.ruleMap.get(rule.getName());
        if (tupleMap == null) {
            tupleMap = new HashMap<TupleKey, Object>();
            this.ruleMap.put(rule.getName(), tupleMap);
        }
        tupleMap.put(tupleKey, obj);
    }

    Object remove(Rule rule, TupleKey tupleKey) {
        Map tupleMap = (Map)this.ruleMap.get(rule.getName());
        if (tupleMap == null) {
            return null;
        }
        Object val = tupleMap.remove(tupleKey);
        if (tupleMap.values().size() == 0) {
            this.ruleMap.remove(rule.getName());
        }
        return val;
    }

    public boolean isEmpty() {
        return this.ruleMap.isEmpty();
    }

    void removeAll(RemoveDelegate removeDelegate) {
        Iterator tupleMapList = this.ruleMap.values().iterator();
        while (tupleMapList.hasNext()) {
            Map tupleMap = (Map)tupleMapList.next();
            Iterator itemList = tupleMap.values().iterator();
            while (itemList.hasNext()) {
                Object item = itemList.next();
                removeDelegate.processRemove(item);
                itemList.remove();
            }
            tupleMapList.remove();
        }
    }

    static interface RemoveDelegate {
        public void processRemove(Object var1);
    }
}

