/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.transformers.textformat;

import de.vandermeer.skb.interfaces.transformers.IsTransformer;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

public interface Text_To_WrappedFormat
extends IsTransformer<String, Pair<ArrayList<String>, ArrayList<String>>> {
    public static final String LINEBREAK = "<br />";

    default public int getWidth() {
        return 80;
    }

    default public Pair<Integer, Integer> getTopSettings() {
        return null;
    }

    @Override
    default public Pair<ArrayList<String>, ArrayList<String>> transform(String input) {
        int count;
        Validate.notBlank((CharSequence)input);
        Validate.isTrue((this.getWidth() > 0 ? 1 : 0) != 0);
        ArrayList<String> topList = new ArrayList<String>();
        ArrayList<String> bottomList = new ArrayList<String>();
        String text = StringUtils.replacePattern((String)input, (String)"\\r\\n|\\r|\\n", (String)LINEBREAK);
        text = StringUtils.replace((String)text, (String)"<br>", (String)LINEBREAK);
        text = StringUtils.replace((String)text, (String)"<br/>", (String)LINEBREAK);
        StrBuilder sb = new StrBuilder(text);
        if (this.getTopSettings() != null) {
            Validate.notNull((Object)this.getTopSettings().getLeft());
            Validate.notNull((Object)this.getTopSettings().getRight());
            Validate.isTrue(((Integer)this.getTopSettings().getLeft() > 0 ? 1 : 0) != 0);
            Validate.isTrue(((Integer)this.getTopSettings().getRight() > 0 ? 1 : 0) != 0);
            int topLines = (Integer)this.getTopSettings().getLeft();
            int topWidth = (Integer)this.getTopSettings().getRight();
            count = 0;
            while (sb.size() > 0 && topLines > 0 && count++ < 200) {
                if (sb.startsWith(LINEBREAK)) {
                    sb.replaceFirst(LINEBREAK, "");
                }
                String s = null;
                boolean wln = false;
                if (sb.indexOf(LINEBREAK) > 0) {
                    s = sb.substring(0, sb.indexOf(LINEBREAK));
                    wln = true;
                } else {
                    s = sb.toString();
                }
                String wrap = WordUtils.wrap((String)s, (int)topWidth, (String)LINEBREAK, (boolean)true);
                StrTokenizer tok = new StrTokenizer(wrap, LINEBREAK).setIgnoreEmptyTokens(false);
                String[] ar = tok.getTokenArray();
                if (ar.length <= topLines) {
                    for (String str : ar) {
                        topList.add(str.trim());
                    }
                    if (wln) {
                        sb.replace(0, sb.indexOf(LINEBREAK) + LINEBREAK.length(), "");
                    } else {
                        sb.clear();
                    }
                    topLines = 0;
                    continue;
                }
                StrBuilder replace = new StrBuilder();
                for (int i = 0; i < topLines; ++i) {
                    topList.add(ar[i].trim());
                    replace.appendSeparator(' ').append(ar[i]);
                }
                if (wln) {
                    replace.append(LINEBREAK);
                }
                sb.replaceFirst(replace.toString(), "");
                topLines = 0;
            }
        }
        count = 0;
        while (sb.size() > 0 && count++ < 200) {
            if (sb.startsWith(LINEBREAK)) {
                sb.replaceFirst(LINEBREAK, "");
            }
            String s = null;
            if (sb.indexOf(LINEBREAK) > 0) {
                s = sb.substring(0, sb.indexOf(LINEBREAK));
                sb.replace(0, sb.indexOf(LINEBREAK) + LINEBREAK.length(), "");
            } else {
                s = sb.toString();
                sb.clear();
            }
            s = WordUtils.wrap((String)s, (int)this.getWidth(), (String)LINEBREAK, (boolean)true);
            StrTokenizer tok = new StrTokenizer(s, LINEBREAK).setIgnoreEmptyTokens(false);
            for (String str : tok.getTokenArray()) {
                bottomList.add(str.trim());
            }
        }
        return Pair.of(topList, bottomList);
    }

    public static Text_To_WrappedFormat create(final int width) {
        return new Text_To_WrappedFormat(){

            @Override
            public int getWidth() {
                return width;
            }
        };
    }

    public static Text_To_WrappedFormat create(final int width, final Pair<Integer, Integer> top) {
        return new Text_To_WrappedFormat(){

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public Pair<Integer, Integer> getTopSettings() {
                return top;
            }
        };
    }

    public static Pair<ArrayList<String>, ArrayList<String>> convert(String text, int width) {
        return Text_To_WrappedFormat.create(width).transform(text);
    }

    public static Pair<ArrayList<String>, ArrayList<String>> convert(String text, int width, Pair<Integer, Integer> top) {
        return Text_To_WrappedFormat.create(width, top).transform(text);
    }
}

