/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.skb.interfaces.strategies.collections.set;

import de.vandermeer.skb.interfaces.strategies.collections.IsSetStrategy;
import java.util.Collection;
import java.util.HashSet;

public interface HashSetStrategy<T>
extends IsSetStrategy<HashSet<T>, T> {
    @Override
    default public HashSet<T> get(Collection<T> collection) {
        if (collection == null) {
            return new HashSet();
        }
        return new HashSet<T>(collection);
    }

    @Override
    default public HashSet<T> get() {
        return new HashSet();
    }

    public static <T> HashSetStrategy<T> create() {
        return new HashSetStrategy<T>(){};
    }
}

