/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import heros.fieldsens.AccessPath;
import heros.fieldsens.Debugger;
import heros.fieldsens.FlowFunction;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.PerAccessPathMethodAnalyzer;
import heros.fieldsens.Resolver;
import java.util.Map;
import java.util.Set;

public abstract class ResolverTemplate<Field, Fact, Stmt, Method, Incoming>
extends Resolver<Field, Fact, Stmt, Method> {
    private boolean recursionLock = false;
    protected Set<Incoming> incomingEdges = Sets.newHashSet();
    private ResolverTemplate<Field, Fact, Stmt, Method, Incoming> parent;
    private Map<AccessPath<Field>, ResolverTemplate<Field, Fact, Stmt, Method, Incoming>> nestedResolvers = Maps.newHashMap();
    private Map<AccessPath<Field>, ResolverTemplate<Field, Fact, Stmt, Method, Incoming>> allResolversInExclHierarchy;
    protected AccessPath<Field> resolvedAccessPath;
    protected Debugger<Field, Fact, Stmt, Method> debugger;

    public ResolverTemplate(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, AccessPath<Field> resolvedAccessPath, ResolverTemplate<Field, Fact, Stmt, Method, Incoming> parent, Debugger<Field, Fact, Stmt, Method> debugger) {
        super(analyzer);
        this.resolvedAccessPath = resolvedAccessPath;
        this.parent = parent;
        this.debugger = debugger;
        this.allResolversInExclHierarchy = parent == null || resolvedAccessPath.getExclusions().isEmpty() ? Maps.newHashMap() : parent.allResolversInExclHierarchy;
        debugger.newResolver(analyzer, this);
    }

    protected boolean isLocked() {
        if (this.recursionLock) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.isLocked();
    }

    protected void lock() {
        this.recursionLock = true;
    }

    protected void unlock() {
        this.recursionLock = false;
    }

    protected abstract AccessPath<Field> getAccessPathOf(Incoming var1);

    public void addIncoming(Incoming inc) {
        if (this.resolvedAccessPath.isPrefixOf(this.getAccessPathOf(inc)) == AccessPath.PrefixTestResult.GUARANTEED_PREFIX) {
            this.log("Incoming Edge: " + inc);
            if (!this.incomingEdges.add(inc)) {
                return;
            }
            this.interest(this);
            for (ResolverTemplate nestedResolver : Lists.newLinkedList(this.nestedResolvers.values())) {
                nestedResolver.addIncoming(inc);
            }
            this.processIncomingGuaranteedPrefix(inc);
        } else if (this.getAccessPathOf(inc).isPrefixOf(this.resolvedAccessPath).atLeast(AccessPath.PrefixTestResult.POTENTIAL_PREFIX)) {
            this.processIncomingPotentialPrefix(inc);
        }
    }

    protected abstract void processIncomingPotentialPrefix(Incoming var1);

    protected abstract void processIncomingGuaranteedPrefix(Incoming var1);

    @Override
    public void resolve(FlowFunction.Constraint<Field> constraint, InterestCallback<Field, Fact, Stmt, Method> callback) {
        this.log("Resolve: " + constraint);
        this.debugger.askedToResolve(this, constraint);
        if (constraint.canBeAppliedTo(this.resolvedAccessPath) && !this.isLocked()) {
            AccessPath<Field> newAccPath = constraint.applyToAccessPath(this.resolvedAccessPath);
            ResolverTemplate<Field, Fact, Stmt, Method, Incoming> nestedResolver = this.getOrCreateNestedResolver(newAccPath);
            assert (nestedResolver.resolvedAccessPath.equals(constraint.applyToAccessPath(this.resolvedAccessPath)));
            nestedResolver.registerCallback(callback);
        }
    }

    protected ResolverTemplate<Field, Fact, Stmt, Method, Incoming> getOrCreateNestedResolver(AccessPath<Field> newAccPath) {
        if (this.resolvedAccessPath.equals(newAccPath)) {
            return this;
        }
        if (!this.nestedResolvers.containsKey(newAccPath)) {
            assert (this.resolvedAccessPath.getDeltaTo(newAccPath).accesses.length <= 1);
            if (this.allResolversInExclHierarchy.containsKey(newAccPath)) {
                return this.allResolversInExclHierarchy.get(newAccPath);
            }
            ResolverTemplate nestedResolver = this.createNestedResolver(newAccPath);
            if (!this.resolvedAccessPath.getExclusions().isEmpty() || !newAccPath.getExclusions().isEmpty()) {
                this.allResolversInExclHierarchy.put(newAccPath, nestedResolver);
            }
            this.nestedResolvers.put(newAccPath, nestedResolver);
            for (Object inc : Lists.newLinkedList(this.incomingEdges)) {
                nestedResolver.addIncoming(inc);
            }
            return nestedResolver;
        }
        return this.nestedResolvers.get(newAccPath);
    }

    protected abstract ResolverTemplate<Field, Fact, Stmt, Method, Incoming> createNestedResolver(AccessPath<Field> var1);
}

