/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import com.google.common.collect.Table;
import heros.InterproceduralCFG;
import heros.ItemPrinter;
import heros.solver.IDESolver;
import heros.solver.Pair;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FlowFunctionDotExport<N, D, M, I extends InterproceduralCFG<N, M>> {
    private final IDESolver<N, D, M, ?, I> solver;
    private final ItemPrinter<? super N, ? super D, ? super M> printer;
    private final Set<M> methodWhitelist;

    public FlowFunctionDotExport(IDESolver<N, D, M, ?, I> solver, ItemPrinter<? super N, ? super D, ? super M> printer) {
        this(solver, printer, null);
    }

    public FlowFunctionDotExport(IDESolver<N, D, M, ?, I> solver, ItemPrinter<? super N, ? super D, ? super M> printer, Set<M> methodWhitelist) {
        this.solver = solver;
        this.printer = printer;
        this.methodWhitelist = methodWhitelist;
    }

    private static <K, U> Set<U> getOrMakeSet(Map<K, Set<U>> map, K key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        HashSet toRet = new HashSet();
        map.put(key, toRet);
        return toRet;
    }

    private String escapeLabelString(String toEscape) {
        return toEscape.replace("\\", "\\\\").replace("\"", "\\\"").replace("<", "\\<").replace(">", "\\>");
    }

    private void numberEdges(Table<N, N, Map<D, Set<D>>> edgeSet, UnitFactTracker utf) {
        for (Table.Cell c : edgeSet.cellSet()) {
            Object sourceUnit = c.getRowKey();
            Object destUnit = c.getColumnKey();
            Object destMethod = this.solver.icfg.getMethodOf((Object)destUnit);
            Object sourceMethod = this.solver.icfg.getMethodOf((Object)sourceUnit);
            if (this.isMethodFiltered(sourceMethod) && this.isMethodFiltered(destMethod)) continue;
            if (this.isMethodFiltered(destMethod)) {
                utf.registerStubUnit(destMethod, destUnit);
            } else {
                utf.registerUnit(destMethod, destUnit);
            }
            if (this.isMethodFiltered(sourceMethod)) {
                utf.registerStubUnit(sourceMethod, sourceUnit);
            } else {
                utf.registerUnit(sourceMethod, sourceUnit);
            }
            for (Map.Entry entry : ((Map)c.getValue()).entrySet()) {
                utf.registerFactAtUnit(sourceUnit, entry.getKey());
                for (Object destFact : (Set)entry.getValue()) {
                    utf.registerFactAtUnit(destUnit, destFact);
                }
            }
        }
    }

    private boolean isMethodFiltered(M method) {
        return this.methodWhitelist != null && !this.methodWhitelist.contains(method);
    }

    private boolean isNodeFiltered(N node) {
        return this.isMethodFiltered(this.solver.icfg.getMethodOf(node));
    }

    private void printMethodUnits(Set<N> units, M method, PrintStream pf, UnitFactTracker utf) {
        for (N methodUnit : units) {
            Set loc = (Set)utf.factsForUnit.get(methodUnit);
            String unitText = this.escapeLabelString(this.printer.printNode(methodUnit, method));
            pf.print(utf.getUnitLabel(methodUnit) + " [shape=record,label=\"" + unitText + " ");
            if (loc != null) {
                for (Object hl : loc) {
                    pf.print("| <" + utf.getFactLabel(methodUnit, hl) + "> " + this.escapeLabelString(this.printer.printFact(hl)));
                }
            }
            pf.println("\"];");
        }
    }

    public void dumpDotFile(String fileName) {
        File f = new File(fileName);
        try (PrintStream pf = null;){
            pf = new PrintStream(f);
            UnitFactTracker utf = new UnitFactTracker();
            this.numberEdges(this.solver.computedIntraPEdges, utf);
            this.numberEdges(this.solver.computedInterPEdges, utf);
            pf.println("digraph ifds {node[shape=record];");
            int methodCounter = 0;
            for (Map.Entry kv : utf.methodToUnit.entrySet()) {
                Set intraProc = (Set)kv.getValue();
                pf.println("subgraph cluster" + methodCounter + " {");
                ++methodCounter;
                this.printMethodUnits(intraProc, kv.getKey(), pf, utf);
                for (Object methodUnit : intraProc) {
                    Map flows = this.solver.computedIntraPEdges.row(methodUnit);
                    for (Map.Entry kv2 : flows.entrySet()) {
                        Object destUnit = kv2.getKey();
                        for (Map.Entry pointFlow : ((Map)kv2.getValue()).entrySet()) {
                            for (Object destFact : (Set)pointFlow.getValue()) {
                                String edge = utf.getEdgePoint(methodUnit, pointFlow.getKey()) + " -> " + utf.getEdgePoint(destUnit, destFact);
                                pf.print(edge);
                                pf.println(";");
                            }
                        }
                    }
                }
                pf.println("label=\"" + this.escapeLabelString(this.printer.printMethod(kv.getKey())) + "\";");
                pf.println("}");
            }
            for (Map.Entry kv : utf.stubMethods.entrySet()) {
                pf.println("subgraph cluster" + methodCounter++ + " {");
                this.printMethodUnits((Set)kv.getValue(), kv.getKey(), pf, utf);
                pf.println("label=\"" + this.escapeLabelString("[STUB] " + this.printer.printMethod(kv.getKey())) + "\";");
                pf.println("graph[style=dotted];");
                pf.println("}");
            }
            for (Table.Cell c : this.solver.computedInterPEdges.cellSet()) {
                if (this.isNodeFiltered(c.getRowKey()) && this.isNodeFiltered(c.getColumnKey())) continue;
                for (Map.Entry kv : ((Map)c.getValue()).entrySet()) {
                    for (Object dFact : (Set)kv.getValue()) {
                        pf.print(utf.getEdgePoint(c.getRowKey(), kv.getKey()));
                        pf.print(" -> ");
                        pf.print(utf.getEdgePoint(c.getColumnKey(), dFact));
                        pf.println(" [style=dotted];");
                    }
                }
            }
            pf.println("}");
        }
    }

    private class UnitFactTracker {
        private Numberer<Pair<N, D>> factNumbers = new Numberer();
        private Numberer<N> unitNumbers = new Numberer();
        private Map<N, Set<D>> factsForUnit = new HashMap();
        private Map<M, Set<N>> methodToUnit = new HashMap();
        private Map<M, Set<N>> stubMethods = new HashMap();

        private UnitFactTracker() {
        }

        public void registerFactAtUnit(N unit, D fact) {
            FlowFunctionDotExport.getOrMakeSet(this.factsForUnit, unit).add(fact);
            this.factNumbers.add(new Pair(unit, fact));
        }

        public void registerUnit(M method, N unit) {
            this.unitNumbers.add(unit);
            FlowFunctionDotExport.getOrMakeSet(this.methodToUnit, method).add(unit);
        }

        public void registerStubUnit(M method, N unit) {
            assert (!this.methodToUnit.containsKey(method));
            this.unitNumbers.add(unit);
            FlowFunctionDotExport.getOrMakeSet(this.stubMethods, method).add(unit);
        }

        public String getUnitLabel(N unit) {
            return "u" + this.unitNumbers.get(unit);
        }

        public String getFactLabel(N unit, D fact) {
            return "f" + this.factNumbers.get(new Pair(unit, fact));
        }

        public String getEdgePoint(N unit, D fact) {
            return this.getUnitLabel(unit) + ":" + this.getFactLabel(unit, fact);
        }
    }

    private static class Numberer<D> {
        long counter = 1L;
        Map<D, Long> map = new HashMap<D, Long>();

        private Numberer() {
        }

        public void add(D o) {
            if (this.map.containsKey(o)) {
                return;
            }
            this.map.put(o, this.counter++);
        }

        public long get(D o) {
            if (o == null) {
                throw new IllegalArgumentException("Null key");
            }
            if (!this.map.containsKey(o)) {
                throw new IllegalArgumentException("Failed to find number for: " + o);
            }
            return this.map.get(o);
        }
    }
}

