/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.maven;

import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.maven.SignaturesArtifact;
import de.thetaphi.forbiddenapis.plexus.util.DirectoryScanner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractCheckMojo
extends AbstractMojo
implements Constants {
    @Parameter(required=false)
    private File[] signaturesFiles;
    @Parameter(required=false)
    private SignaturesArtifact[] signaturesArtifacts;
    @Parameter(required=false)
    private String signatures;
    @Parameter(required=false)
    private String[] bundledSignatures;
    @Parameter(required=false, defaultValue="false")
    private boolean failOnUnsupportedJava;
    @Parameter(required=false, defaultValue="true")
    private boolean failOnMissingClasses;
    @Deprecated
    @Parameter(required=false, defaultValue="true")
    private boolean failOnUnresolvableSignatures;
    @Parameter(required=false, defaultValue="false")
    private boolean ignoreSignaturesOfMissingClasses;
    @Parameter(required=false, property="forbiddenapis.failOnViolation", defaultValue="true")
    private boolean failOnViolation;
    @Parameter(required=false, defaultValue="false")
    private boolean disableClassloadingCache;
    @Parameter(required=false, defaultValue="${maven.compiler.target}")
    private String targetVersion;
    @Parameter(required=false)
    private String[] includes;
    @Parameter(required=false)
    private String[] excludes;
    @Parameter(required=false)
    private String[] suppressAnnotations;
    @Parameter(required=false, property="forbiddenapis.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.packaging}", readonly=true, required=true)
    private String packaging;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;

    protected abstract List<String> getClassPathElements();

    protected abstract File getClassesDirectory();

    protected String getTargetVersion() {
        return this.targetVersion;
    }

    private File resolveSignaturesArtifact(SignaturesArtifact signaturesArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact artifact = signaturesArtifact.createArtifact(this.artifactFactory);
        this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        File f = artifact.getFile();
        if (f == null) {
            throw new ArtifactNotFoundException("Artifact does not resolve to a file.", artifact);
        }
        return f;
    }

    private String encodeUrlPath(String path) {
        try {
            return new URI(null, path, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private URL createJarUrl(File f, String jarPath) throws MalformedURLException {
        URL fileUrl = f.toURI().toURL();
        URL jarBaseUrl = new URL("jar", null, fileUrl.toExternalForm() + "!/");
        return new URL(jarBaseUrl, this.encodeUrlPath(jarPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        ClassLoader classLoader;
        Logger log = new Logger(){

            @Override
            public void error(String msg) {
                AbstractCheckMojo.this.getLog().error((CharSequence)msg);
            }

            @Override
            public void warn(String msg) {
                AbstractCheckMojo.this.getLog().warn((CharSequence)msg);
            }

            @Override
            public void info(String msg) {
                AbstractCheckMojo.this.getLog().info((CharSequence)msg);
            }
        };
        if (this.skip) {
            log.info("Skipping forbidden-apis checks.");
            return;
        }
        if ("pom".equals(this.packaging)) {
            log.info("Skipping execution for packaging \"" + this.packaging + "\"");
            return;
        }
        if (this.includes == null) {
            this.includes = new String[]{"**/*.class"};
        }
        List<String> cp = this.getClassPathElements();
        URL[] urls = new URL[cp.size()];
        try {
            int i = 0;
            for (String cpElement : cp) {
                urls[i++] = new File(cpElement).toURI().toURL();
            }
            assert (i == urls.length);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to build classpath.", (Exception)e);
        }
        URLClassLoader urlLoader = null;
        if (urls.length > 0) {
            urlLoader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
            classLoader = urlLoader;
        } else {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ClassLoader loader = classLoader;
        try {
            EnumSet<Checker.Option> options = EnumSet.noneOf(Checker.Option.class);
            if (this.failOnMissingClasses) {
                options.add(Checker.Option.FAIL_ON_MISSING_CLASSES);
            }
            if (this.failOnViolation) {
                options.add(Checker.Option.FAIL_ON_VIOLATION);
            }
            if (this.failOnUnresolvableSignatures) {
                options.add(Checker.Option.FAIL_ON_UNRESOLVABLE_SIGNATURES);
            } else {
                log.warn("The setting 'failOnUnresolvableSignatures' was deprecated and will be removed in next version. Use 'ignoreSignaturesOfMissingClasses' instead.");
            }
            if (this.ignoreSignaturesOfMissingClasses) {
                options.add(Checker.Option.IGNORE_SIGNATURES_OF_MISSING_CLASSES);
            }
            if (this.disableClassloadingCache) {
                options.add(Checker.Option.DISABLE_CLASSLOADING_CACHE);
            }
            Checker checker = new Checker(log, loader, options);
            if (!checker.isSupportedJDK) {
                String msg = String.format(Locale.ENGLISH, "Your Java runtime (%s %s) is not supported by the forbiddenapis MOJO. Please run the checks with a supported JDK!", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"));
                if (this.failOnUnsupportedJava) {
                    throw new MojoExecutionException(msg);
                }
                log.warn(msg);
                return;
            }
            if (this.suppressAnnotations != null) {
                for (String a : this.suppressAnnotations) {
                    checker.addSuppressAnnotation(a);
                }
            }
            log.info("Scanning for classes to check...");
            File classesDirectory = this.getClassesDirectory();
            if (!classesDirectory.exists()) {
                log.info("Classes directory does not exist, forbiddenapis check skipped: " + classesDirectory);
                return;
            }
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(classesDirectory);
            ds.setCaseSensitive(true);
            ds.setIncludes(this.includes);
            ds.setExcludes(this.excludes);
            ds.addDefaultExcludes();
            ds.scan();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                log.info(String.format(Locale.ENGLISH, "No classes found in '%s' (includes=%s, excludes=%s), forbiddenapis check skipped.", classesDirectory.toString(), Arrays.toString(this.includes), Arrays.toString(this.excludes)));
                return;
            }
            try {
                String sig;
                if (this.bundledSignatures != null) {
                    String targetVersion = this.getTargetVersion();
                    if ("".equals(targetVersion)) {
                        targetVersion = null;
                    }
                    if (targetVersion == null) {
                        log.warn("The 'targetVersion' parameter or '${maven.compiler.target}' property is missing. Trying to read bundled JDK signatures without compiler target. You have to explicitly specify the version in the resource name.");
                    }
                    for (String bs : new LinkedHashSet<String>(Arrays.asList(this.bundledSignatures))) {
                        checker.addBundledSignatures(bs, targetVersion);
                    }
                }
                LinkedHashSet<File> sigFiles = new LinkedHashSet<File>();
                LinkedHashSet<URL> sigUrls = new LinkedHashSet<URL>();
                if (this.signaturesFiles != null) {
                    sigFiles.addAll(Arrays.asList(this.signaturesFiles));
                }
                if (this.signaturesArtifacts != null) {
                    for (SignaturesArtifact artifact : this.signaturesArtifacts) {
                        File f = this.resolveSignaturesArtifact(artifact);
                        if (artifact.path != null) {
                            if (f.isDirectory()) {
                                sigFiles.add(new File(f, artifact.path));
                                continue;
                            }
                            sigUrls.add(this.createJarUrl(f, artifact.path));
                            continue;
                        }
                        sigFiles.add(f);
                    }
                }
                for (File f : sigFiles) {
                    checker.parseSignaturesFile(f);
                }
                for (URL u : sigUrls) {
                    checker.parseSignaturesFile(u);
                }
                String string = sig = this.signatures != null ? this.signatures.trim() : null;
                if (sig != null && sig.length() != 0) {
                    checker.parseSignaturesString(sig);
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("IO problem while reading files with API signatures.", (Exception)ioe);
            }
            catch (ParseException pe) {
                throw new MojoExecutionException("Parsing signatures failed: " + pe.getMessage(), (Exception)pe);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Problem while resolving Maven artifact.", (Exception)((Object)e));
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoExecutionException("Maven artifact does not exist.", (Exception)((Object)e));
            }
            if (checker.hasNoSignatures()) {
                if (checker.noSignaturesFilesParsed()) {
                    throw new MojoExecutionException("No signatures were added to mojo; use parameters 'signatures', 'bundledSignatures', 'signaturesFiles',  and/or 'signaturesArtifacts' to define those!");
                }
                log.info("Skipping execution because no API signatures are available.");
                return;
            }
            try {
                checker.addClassesToCheck(classesDirectory, files);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to load one of the given class files.", (Exception)ioe);
            }
            try {
                checker.run();
            }
            catch (ForbiddenApiException fae) {
                throw new MojoExecutionException(fae.getMessage(), fae.getCause());
            }
        }
        finally {
            try {
                if (urlLoader != null) {
                    urlLoader.close();
                }
            }
            catch (IOException ioe) {
                log.warn("Cannot close classloader: ".concat(ioe.toString()));
            }
        }
    }
}

