/*
 * Decompiled with CFR 0.152.
 */
package streams.runtime;

import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.io.Source;
import stream.runtime.ProcessContainer;

public class SoftShutdown
extends Thread {
    static Logger log = LoggerFactory.getLogger(SoftShutdown.class);
    final ProcessContainer pc;

    public SoftShutdown(ProcessContainer pc) {
        this.pc = pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set roots = this.pc.computeGraph().getRootSources();
        log.info("Graph has {} root source elements: ", (Object)roots.size(), (Object)roots);
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            Source source = (Source)it.next();
            log.info("Removing element '{}' from compute-graph", (Object)source);
            Set to = this.pc.computeGraph().getTargets((Object)source);
            log.info("{} elements are reading from {}", (Object)to.size(), (Object)source.getId());
            try {
                source.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                it.remove();
            }
            log.info("Root sources remaining: {}", (Object)roots);
        }
    }
}

