/*
 * Decompiled with CFR 0.152.
 */
package stream.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Process;
import stream.io.Source;
import stream.service.Service;
import streams.application.ComputeGraph;

public class PrintGraph {
    static Logger log = LoggerFactory.getLogger(PrintGraph.class);

    protected static String toString(ComputeGraph g) {
        log.info("######## Sources ########");
        for (Object o : g.getSources()) {
            if (!(o instanceof Source)) continue;
            log.info("########" + o.toString() + "########");
            for (Object t : g.getTargets(o)) {
                log.info("\t==> " + t.toString());
            }
        }
        log.info("######## RootSources ########");
        for (Object o : g.getRootSources()) {
            log.info(o.toString());
        }
        log.info("######## NonRefSinks ########");
        for (Object o : g.getNonRefQueues()) {
            log.info("########" + o.toString() + "########");
            for (Object t : g.getSourcesFor(o)) {
                log.info("\t==> " + t.toString());
            }
        }
        return "";
    }

    public static String print(ComputeGraph graph) {
        Service p;
        String id;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        String prefix = "  ";
        out.println("  {");
        Iterator it = graph.sources().keySet().iterator();
        if (it.hasNext()) {
            out.println("   'sources': [");
            while (it.hasNext()) {
                String src = (String)it.next();
                Source source = (Source)graph.sources().get(src);
                out.print("  \t{ 'id': '" + source.getId() + "', 'class': '" + source.getClass().getCanonicalName() + "' }");
                if (it.hasNext()) {
                    out.println(",");
                    continue;
                }
                out.println("");
            }
            out.println("     ],");
        }
        if ((it = graph.services().keySet().iterator()).hasNext()) {
            out.println("   'services': [");
            while (it.hasNext()) {
                id = (String)it.next();
                p = (Service)graph.services().get(id);
                out.print("  \t{ 'id': '" + id + "',  'class': '" + p.getClass().getCanonicalName() + "' }");
                if (it.hasNext()) {
                    out.println(",");
                    continue;
                }
                out.println("");
            }
            out.println("  ]");
        }
        out.println("   'processes': [");
        it = graph.processes().keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            p = (Process)graph.processes().get(id);
            out.print("  \t{ 'id': '" + id + "', 'input': '" + p.getInput().getId() + "', 'class': '" + p.getClass().getCanonicalName() + "' }");
            if (it.hasNext()) {
                out.println(",");
                continue;
            }
            out.println("");
        }
        out.println("    ]");
        out.println("  }");
        out.flush();
        out.close();
        return sw.toString();
    }
}

