/*
 * Decompiled with CFR 0.152.
 */
package stream.shell;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.DebugShell;
import stream.runtime.rpc.ContainerAnnouncement;
import stream.runtime.rpc.Discovery;
import stream.runtime.rpc.RMIClient;
import stream.service.ServiceInfo;
import stream.shell.Command;

public class List
extends Command {
    static Logger log = LoggerFactory.getLogger(List.class);
    Discovery discovery = new Discovery();

    public List(DebugShell shell) throws Exception {
        super(shell);
    }

    @Override
    public String execute(String[] args) {
        this.println("\nServices Available:\n----------\n");
        int id = 1;
        try {
            this.discovery.discover();
            for (String key : this.discovery.getAnnouncements().keySet()) {
                RMIClient remote;
                ContainerAnnouncement ref = this.discovery.getAnnouncements().get(key);
                if (this.shell.getNamingService().getContainer(key) != null) {
                    log.debug("Container already known: {}", (Object)this.shell.getNamingService().getContainer(key));
                    remote = this.shell.getNamingService().getContainer(key);
                } else {
                    remote = new RMIClient(ref.getHost(), ref.getPort());
                    this.shell.getNamingService().addContainer(key, remote);
                }
                Map infos = remote.list();
                for (String name : infos.keySet()) {
                    if (name.startsWith("//" + key + "/.")) continue;
                    ServiceInfo info = (ServiceInfo)infos.get(name);
                    StringBuffer services = new StringBuffer("[");
                    for (int i = 0; i < info.getServices().length; ++i) {
                        services.append(info.getServices()[i].getCanonicalName());
                        if (i + 1 >= info.getServices().length) continue;
                        services.append(", ");
                    }
                    services.append("]");
                    this.print("  #" + id);
                    this.println("    " + name + "   " + services.toString());
                    this.shell.set("#" + id, name);
                    ++id;
                }
            }
            this.println("");
        }
        catch (Exception e) {
            this.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
        return "";
    }
}

