/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.CopiesUtils;
import stream.Copy;
import stream.io.Sink;
import stream.runtime.DependencyInjection;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.setup.factory.ObjectFactory;
import stream.runtime.setup.handler.ProcessElementHandler;
import stream.util.Variables;
import streams.application.ComputeGraph;

public class SinkElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(ProcessElementHandler.class);

    @Override
    public String getKey() {
        return "Sink";
    }

    @Override
    public boolean handlesElement(Element element) {
        return this.getKey().equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables, DependencyInjection dependencyInjection) throws Exception {
        String id = element.getAttribute("id");
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("No 'id' attribute defined for sink!");
        }
        String copiesString = element.getAttribute("copies");
        Copy[] copies = null;
        if (copiesString != null && !copiesString.isEmpty()) {
            copiesString = variables.expand(copiesString);
            copies = CopiesUtils.parse((String)copiesString);
        } else {
            Copy c = new Copy();
            c.setId(id);
            copies = new Copy[]{c};
        }
        if (copies == null) {
            log.info("queues where not created, due to 'zero' copies");
            return;
        }
        ComputeGraph computeGraph = container.computeGraph();
        String className = element.getAttribute("class");
        if (className == null || className.trim().isEmpty()) {
            throw new IllegalArgumentException("class attribute is missing ");
        }
        Map<String, String> params = container.getObjectFactory().getAttributes(element);
        if (!params.containsKey("class")) {
            throw new IllegalArgumentException("class attribute is missing ");
        }
        for (Copy copy : copies) {
            Variables local = new Variables(variables);
            CopiesUtils.addCopyIds((Variables)local, (Copy)copy);
            String cid = local.expand(id);
            Sink sink = (Sink)container.getObjectFactory().create(className, params, ObjectFactory.createConfigDocument(element), local);
            container.registerSink(cid, sink);
            log.info("register sink: {}", (Object)cid);
            computeGraph.addSink(cid, sink);
            log.info("add sink to compute graph: {}", (Object)cid);
        }
    }
}

