/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.CopiesUtils;
import stream.Processor;
import stream.ProcessorList;
import stream.container.IContainer;
import stream.io.Sink;
import stream.runtime.DependencyInjection;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.runtime.setup.factory.DefaultProcessFactory;
import stream.runtime.setup.factory.ObjectFactory;
import stream.runtime.setup.factory.ProcessConfiguration;
import stream.runtime.setup.factory.ProcessorFactory;
import stream.service.Service;
import stream.util.Variables;
import streams.application.ComputeGraph;
import streams.application.Reference;

public class ProcessElementHandler
implements ElementHandler {
    static Logger log = LoggerFactory.getLogger(ProcessElementHandler.class);
    protected final ObjectFactory objectFactory;
    protected final ProcessorFactory processorFactory;
    protected final String defaultProcessImplementation = "stream.runtime.DefaultProcess";

    public ProcessElementHandler(ObjectFactory objectFactory, ProcessorFactory processorFactory) {
        this.objectFactory = objectFactory;
        this.processorFactory = processorFactory;
    }

    @Override
    public String getKey() {
        return "Process";
    }

    @Override
    public boolean handlesElement(Element element) {
        return "process".equalsIgnoreCase(element.getNodeName());
    }

    @Override
    public void handleElement(ProcessContainer container, Element element, Variables variables, DependencyInjection dependencyInjection) throws Exception {
        DefaultProcessFactory pf = new DefaultProcessFactory(container, this.objectFactory, dependencyInjection);
        ProcessConfiguration[] configs = pf.createConfigurations(element, variables);
        pf.createAndRegisterProcesses(configs);
    }

    protected Processor createProcessor(IContainer container, Element child, Variables local, DependencyInjection dependencyInjection) throws Exception {
        Map<String, String> params = this.objectFactory.getAttributes(child);
        ComputeGraph computeGraph = container.computeGraph();
        Object o = this.objectFactory.create(child, params, local);
        if (o instanceof ProcessorList) {
            NodeList children = child.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                Processor proc = this.createProcessor(container, element, local, dependencyInjection);
                if (proc != null) {
                    ((ProcessorList)o).getProcessors().add(proc);
                    continue;
                }
                log.warn("Nested element {} is not of type 'stream.data.Processor': ", (Object)node.getNodeName());
            }
            return (Processor)o;
        }
        if (o instanceof Processor) {
            if (params.containsKey("id") && !"".equals(params.get("id").trim())) {
                if (o instanceof Service) {
                    String id = params.get("id").trim();
                    id = local.expand(id);
                    log.debug("Registering processor with id '{}' in look-up service", (Object)id);
                    container.getNamingService().register(id, (Service)o);
                } else {
                    log.warn("Processor '{}' specifies an ID attribute '{}' but does not implement a Service interface. Processor will *not* be registered!", (Object)o.getClass().getName(), (Object)params.get("id"));
                }
            }
            Iterator<String> iterator = params.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String k = key = iterator.next();
                if (key.endsWith("-ref")) {
                    throw new Exception("'-ref' attributes are no longer supported!");
                }
                String value = local.expand(params.get(k));
                Class<? extends Sink> sinkClass = DependencyInjection.hasSinkSetter(key, o);
                if (sinkClass != null) {
                    log.debug("Found queue-injection for key '{}' in processor '{}'", (Object)key, o);
                    String[] refs = CopiesUtils.parseIds((String)value, (boolean)true);
                    ComputeGraph.SinkRef sinkRefs = new ComputeGraph.SinkRef(o, key, refs);
                    computeGraph.addReference(sinkRefs);
                    dependencyInjection.add((Reference)sinkRefs);
                    log.debug("Adding QueueRef to '{}' for object {}", (Object)refs, o);
                    continue;
                }
                Class<? extends Service> serviceClass = DependencyInjection.hasServiceSetter(key, o);
                if (serviceClass == null) continue;
                log.debug("Found service setter for key '{}' in processor {}", (Object)key, o);
                String[] refs = CopiesUtils.parseIds((String)value, (boolean)true);
                log.debug("Adding ServiceRef to '{}' for object {}", (Object)refs, o);
                ComputeGraph.ServiceRef serviceRef = new ComputeGraph.ServiceRef(o, key, refs, serviceClass);
                computeGraph.addReference(serviceRef);
                dependencyInjection.add((Reference)serviceRef);
            }
            return (Processor)o;
        }
        return null;
    }

    protected List<Processor> createNestedProcessors(IContainer container, Element child, Variables local, DependencyInjection dependencyInjection) throws Exception {
        ArrayList<Processor> procs = new ArrayList<Processor>();
        NodeList pnodes = child.getChildNodes();
        for (int j = 0; j < pnodes.getLength(); ++j) {
            Processor p;
            Node cnode = pnodes.item(j);
            if (cnode.getNodeType() != 1 || (p = this.createProcessor(container, (Element)cnode, local, dependencyInjection)) == null) continue;
            log.debug("Found processor...");
            procs.add(p);
        }
        return procs;
    }
}

