/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.Parameter;
import stream.annotations.ParameterException;
import stream.runtime.setup.ParameterMethodInjection;

public class ParameterValidator {
    static Logger log = LoggerFactory.getLogger(ParameterValidator.class);

    public static boolean check(Object o, Map<String, Object> vals) throws ParameterException {
        Map<String, Class<?>> types = ParameterValidator.checkClassParameters(o.getClass(), vals);
        log.debug("Object {} has {} paramters: {}", new Object[]{o, types.size(), types});
        return true;
    }

    public static Map<String, Class<?>> checkClassParameters(Class<?> clazz, Map<String, ?> vals) throws ParameterException {
        Method[] methods;
        Field[] fields;
        LinkedHashMap params = new LinkedHashMap();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Parameter info = field.getAnnotation(Parameter.class);
            if (info == null) continue;
            String name = info.name();
            if (name == null || name.isEmpty()) {
                name = field.getName();
            }
            log.debug("Found parameter '{}' for field '{}'", (Object)name, (Object)field.getName());
            params.put(name, field.getType());
            if (!info.required() || vals.containsKey(name)) continue;
            throw new ParameterException("Field '" + name + "' of class '" + clazz.getCanonicalName() + "' is missing required value!");
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Class<?> mtype;
            String name;
            Parameter p = method.getAnnotation(Parameter.class);
            if (p == null || (name = ParameterMethodInjection.getParameterName(method)) == null) continue;
            if (params.containsKey(name) && p != null && !(mtype = method.getParameterTypes()[0]).equals(params.get(name))) {
                throw new ParameterException("Input type '" + mtype.getName() + "' of set-method '" + clazz.getSimpleName() + "." + method.getName() + "' for parameter '" + name + "' does not match type '" + ((Class)params.get(name)).getName() + "' defined by field annotation!");
            }
            if (p.required() && !vals.containsKey(name)) {
                throw new ParameterException("Missing value for parameter '" + name + "'!");
            }
            params.put(name, method.getParameterTypes()[0]);
        }
        return params;
    }
}

