/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import stream.runtime.setup.ParameterDiscovery;
import stream.runtime.setup.ParameterFinder;
import stream.runtime.setup.ParameterInjection;
import stream.util.Variables;

public class DefaultParameterFinder
implements ParameterFinder {
    static final List<ParameterFinder> finders = new ArrayList<ParameterFinder>();

    @Override
    public Map<String, Class<?>> findParameters(Class<?> clazz) {
        Map<String, Class<?>> params = ParameterDiscovery.discoverParameters(clazz);
        for (ParameterFinder finder : finders) {
            params.putAll(finder.findParameters(clazz));
        }
        return params;
    }

    @Override
    public Set<String> inject(Map<String, ?> params, Object o) throws Exception {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(ParameterInjection.inject(o, params, new Variables()));
        for (ParameterFinder finder : finders) {
            set.addAll(finder.inject(params, o));
        }
        return set;
    }
}

