/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.ApplicationContext;
import stream.runtime.LifeCycle;
import stream.runtime.rpc.Announcer;
import stream.runtime.rpc.ContainerAnnouncement;
import stream.runtime.rpc.Discovery;
import stream.runtime.rpc.RMIClient;
import stream.runtime.rpc.RMIServiceDelegator;
import stream.runtime.rpc.RemoteEndpoint;
import stream.runtime.rpc.RemoteNamingService;
import stream.runtime.rpc.ServiceProxy;
import stream.service.NamingService;
import stream.service.Service;
import stream.service.ServiceInfo;

public class RMINamingService
extends UnicastRemoteObject
implements RemoteNamingService,
LifeCycle {
    private static final long serialVersionUID = 3886371094536580516L;
    static Logger log = LoggerFactory.getLogger(RMINamingService.class);
    final String name;
    final String namespace;
    final Registry registry;
    final Map<String, ServiceInfo> classes = new LinkedHashMap<String, ServiceInfo>();
    Announcer announcer;
    Discovery discoverer;
    ContainerAnnouncement announcement;
    Map<String, NamingService> container = new LinkedHashMap<String, NamingService>();

    public RMINamingService() throws Exception {
        this("local");
    }

    public RMINamingService(String name) throws Exception {
        this(name, "localhost", 0, true);
    }

    public RMINamingService(String name, String host, int port) throws Exception {
        this(name, host, port, false);
    }

    public RMINamingService(String name, String host, int port, boolean announce) throws Exception {
        this.name = name;
        this.namespace = "//" + name + "/";
        log.debug("Looking up host address {}", (Object)host);
        InetAddress address = InetAddress.getByName(host);
        String hostAddress = address.getHostAddress();
        log.debug("Host address is {}", (Object)hostAddress);
        System.setProperty("java.rmi.server.hostname", hostAddress);
        String[] names = null;
        Registry reg = null;
        if (port <= 0) {
            log.debug("Checking for free port...");
            port = RMINamingService.getFreePort();
            log.debug("Using port {}", (Object)port);
        }
        try {
            reg = LocateRegistry.getRegistry(port);
            names = reg.list();
            log.debug("Found existing registry, names: {}", (Object[])names);
        }
        catch (Exception e) {
            log.debug("No RMI-registry exists as port {}: a new one will be created.", (Object)port);
        }
        try {
            if (names == null) {
                log.debug("Trying to create new registry at port {}", (Object)port);
                this.registry = LocateRegistry.createRegistry(port);
                log.debug("New registry has registered objects: {}", (Object[])this.registry.list());
            } else {
                this.registry = reg;
            }
        }
        catch (Exception e) {
            log.error("Failed to create registry at port {}: {}", (Object)port, (Object)e.getMessage());
            throw new Exception("Failed to create RMI registry at port " + port + ": " + e.getMessage());
        }
        log.debug("my rmi server name is: {}", (Object)address.getHostAddress());
        log.debug("Binding myself to RMI...");
        this.registry.rebind("__NAMING_SERVICE_DIRECTORY__", this);
        this.announcement = new ContainerAnnouncement(name, "rmi", address.getHostAddress(), port);
        log.debug("Announcement will be: {}", (Object)this.announcement);
        if (announce) {
            this.announcer = new Announcer(9200, this.announcement);
            this.announcer.setDaemon(true);
            this.announcer.start();
        }
    }

    public static int getFreePort() throws Exception {
        ServerSocket sock = new ServerSocket(0);
        int port = sock.getLocalPort();
        sock.close();
        return port;
    }

    public void addContainer(String key, NamingService remoteNamingService) throws Exception {
        this.container.put(key, remoteNamingService);
    }

    protected void discover() {
        try {
            Discovery discovery = new Discovery();
            discovery.discover();
            Map<String, ContainerAnnouncement> containers = discovery.getAnnouncements();
            for (String key : containers.keySet()) {
                ContainerAnnouncement info = containers.get(key);
                log.debug("found   {} => {}", (Object)key, (Object)info);
                if (info.equals(this.announcement)) {
                    log.debug("  => That's me!");
                    continue;
                }
                RMIClient remote = new RMIClient(info.getHost(), info.getPort());
                log.debug("Created new NamingService-connection for container {}: {}", (Object)key, (Object)remote);
                Map services = remote.list();
                log.debug("RemoteServices are:");
                for (String s : services.keySet()) {
                    log.debug("   {} = {}", (Object)s, services.get(s));
                }
                this.container.put(key, remote);
                log.debug("Remote-connection added...");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String discover(String container) throws Exception {
        Discovery discovery = new Discovery();
        discovery.discover();
        Map<String, String> containers = discovery.getContainerURLs();
        if (containers == null || !containers.containsKey(container)) {
            throw new Exception("No container found for name '" + container + "'!");
        }
        log.debug("Found container {}: {}", (Object)container, (Object)containers.get(container));
        return containers.get(container);
    }

    protected boolean isLocal(String ref) {
        if (!ref.startsWith("//")) {
            return true;
        }
        return ref.startsWith(this.namespace);
    }

    protected String getContainerName(String ref) {
        if (!ref.startsWith("//")) {
            return this.name;
        }
        int idx = ref.indexOf("/", 3);
        if (idx < 0) {
            return null;
        }
        return ref.substring(2, idx);
    }

    protected String getLocalRef(String ref) {
        if (this.isLocal(ref)) {
            if (!ref.startsWith(this.namespace)) {
                return this.namespace + ref;
            }
            return ref;
        }
        return null;
    }

    public <T extends Service> T lookup(String ref, Class<T> serviceClass) throws Exception {
        log.debug("Received lookup for {} ({})", (Object)ref, serviceClass);
        if (!this.isLocal(ref)) {
            log.debug("Current list of known containers:");
            for (String key : this.container.keySet()) {
                log.debug("   {} => {}", (Object)this.container.get(key));
            }
            String con = this.getContainerName(ref);
            if (this.container.containsKey(con)) {
                log.debug("Found container-ref {}", (Object)con);
                NamingService namingService = this.container.get(con);
                log.debug("remote end-point is: {}", (Object)namingService);
                return (T)namingService.lookup(ref, serviceClass);
            }
            log.debug("Container reference is '{}'", (Object)con);
            if (con == null) {
                throw new Exception("Failed to determine container for reference '" + ref + "'!");
            }
            NamingService ns = this.container.get(con);
            if (ns == null) {
                String url = this.discover(con);
                log.debug("Discovered container {} at {}", (Object)con, (Object)url);
                throw new Exception("No container known for name '" + con + "'!");
            }
            return (T)ns.lookup(ref, serviceClass);
        }
        String localRef = this.getLocalRef(ref);
        if (localRef == null) {
            throw new Exception("No local reference for '" + ref + "'!");
        }
        RemoteEndpoint re = (RemoteEndpoint)this.registry.lookup(localRef);
        if (re == null) {
            throw new Exception("No service entity found for reference '" + ref + "'!");
        }
        ServiceInfo info = this.classes.get(localRef);
        if (info == null) {
            throw new Exception("No service information available for '" + ref + "'!");
        }
        log.debug("Creating proxy for {}, service interfaces: {}", (Object)ref, (Object)this.classes.get(ref));
        Service service = (Service)Proxy.newProxyInstance(re.getClass().getClassLoader(), info.getServices(), (InvocationHandler)new RMIServiceDelegator(re));
        log.debug("Service lookup of '{}' => {}", (Object)localRef, (Object)service);
        return (T)service;
    }

    public void register(String ref, Service p) throws Exception {
        Class<? extends Service>[] services = ServiceProxy.getServiceInterfaces(p);
        if (services.length == 0) {
            log.error("Object {} does not implement a service!", (Object)p);
            throw new Exception("Object " + p + " does not implement a service interface!");
        }
        log.debug("Service {} registered as {}.", (Object)p, (Object)ref);
        ServiceProxy proxy = new ServiceProxy(p);
        String localRef = this.getLocalRef(ref);
        if (localRef == null) {
            throw new Exception("Cannot resolve reference '" + ref + "' as local reference!");
        }
        this.registry.rebind(localRef, proxy);
        this.classes.put(localRef, ServiceInfo.createServiceInfo((String)localRef, (Service)p));
        log.debug("After registration, classes are: {}", this.classes);
    }

    public void unregister(String ref) throws Exception {
        String localRef = this.getLocalRef(ref);
        if (localRef == null) {
            throw new Exception("Cannot resolve reference '" + ref + "' as local reference!");
        }
        log.debug("Service {} unregistered.", (Object)ref);
        this.registry.unbind(localRef);
        this.classes.remove(localRef);
        log.debug("After un-registration, classes are: {}", this.classes);
    }

    public Map<String, ServiceInfo> list() throws Exception {
        log.debug("list() query received, classes are: {}", this.classes);
        LinkedHashMap<String, ServiceInfo> lst = new LinkedHashMap<String, ServiceInfo>();
        for (String key : this.classes.keySet()) {
            if (this.classes.get(key) == null) continue;
            ServiceInfo info = this.classes.get(key);
            log.debug("Adding info {} for service {}", (Object)info, (Object)key);
            lst.put(key, info);
        }
        return lst;
    }

    @Override
    public Map<String, String> getServiceInfo(String name) throws RemoteException {
        log.debug("Query for service-info on {} received!", (Object)name);
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        ServiceInfo serviceInfo = this.classes.get(this.getLocalRef(name));
        Class clazz = serviceInfo.getServices()[0];
        info.put("name", name);
        for (Method m : clazz.getMethods()) {
            StringBuffer args = new StringBuffer();
            Class<?>[] types = m.getParameterTypes();
            if (types != null && types.length > 0) {
                for (int i = 0; i < types.length; ++i) {
                    args.append(types[i].getCanonicalName());
                    if (i + 1 >= types.length) continue;
                    args.append(",");
                }
            }
            String returnType = "void";
            if (m.getReturnType() != null) {
                returnType = m.getReturnType().getCanonicalName();
            }
            info.put("method:" + m.getName() + "(" + args.toString() + ")", returnType);
        }
        log.debug("Returning info {}", info);
        return info;
    }

    @Override
    public Serializable call(String name, String method, String signature, Serializable ... args) throws RemoteException {
        try {
            log.debug("calling '{}.{}'", (Object)name, (Object)method);
            log.debug("   args: {}", (Object[])args);
            ArrayList<Serializable> params = new ArrayList<Serializable>();
            for (int i = 0; i < args.length; ++i) {
                params.add(args[i]);
            }
            RemoteEndpoint re = (RemoteEndpoint)this.registry.lookup(this.getLocalRef(name));
            return re.call(method, signature, params);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void finish() throws Exception {
        this.announcer.finish();
    }

    public void init(ApplicationContext context) throws Exception {
    }
}

