/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.rpc;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.rpc.RemoteNamingService;
import stream.service.NamingService;
import stream.service.Service;
import stream.service.ServiceInfo;

public class RMIClient
implements RemoteNamingService {
    static Logger log = LoggerFactory.getLogger(RMIClient.class);
    final String host;
    final int port;
    final Registry registry;
    RemoteNamingService namingService;
    Map<String, NamingService> remotes = new LinkedHashMap<String, NamingService>();

    public RMIClient(int port) throws Exception {
        this("127.0.0.1", port);
    }

    public RMIClient(String host, int port) throws Exception {
        this.host = host;
        this.port = port;
        String codeBase = System.getProperty("java.rmi.server.codebase", "");
        if (!codeBase.contains("http://" + host + ":9999/")) {
            codeBase = codeBase.isEmpty() ? "http://" + host + ":9999/" : codeBase + " http://" + host + ":9999/";
        }
        System.setProperty("java.rmi.server.codebase", codeBase);
        this.registry = LocateRegistry.getRegistry(host, port);
        log.debug("Registry is: {}", (Object)this.registry);
        this.namingService = (RemoteNamingService)this.registry.lookup("__NAMING_SERVICE_DIRECTORY__");
        log.debug("NamingService is: {}", (Object)this.namingService);
    }

    public <T extends Service> T lookup(String ref, Class<T> serviceClass) throws Exception {
        return (T)this.namingService.lookup(ref, serviceClass);
    }

    public void register(String ref, Service p) throws Exception {
    }

    public void unregister(String ref) throws Exception {
    }

    public Map<String, ServiceInfo> list() throws Exception {
        return this.namingService.list();
    }

    @Override
    public Map<String, String> getServiceInfo(String name) throws RemoteException {
        return this.namingService.getServiceInfo(name);
    }

    @Override
    public Serializable call(String name, String method, String signature, Serializable ... args) throws RemoteException {
        return this.namingService.call(name, method, signature, args);
    }

    public void addContainer(String key, NamingService remoteNamingService) throws Exception {
        this.remotes.put(key, remoteNamingService);
    }

    public String toString() {
        return "rmi://" + this.host + ":" + this.port;
    }
}

