/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Process;
import stream.runtime.ApplicationContext;
import stream.runtime.ProcessListener;
import streams.runtime.Hook;

public class ProcessThread
extends Thread
implements Hook {
    static Logger log = LoggerFactory.getLogger(ProcessThread.class);
    static final Map<String, Integer> PRIORITY_NAMES = new LinkedHashMap<String, Integer>();
    final Process process;
    final ApplicationContext context;
    final AtomicBoolean executing = new AtomicBoolean(false);
    boolean running = false;
    protected final List<ProcessListener> processListener = new ArrayList<ProcessListener>();

    public ProcessThread(Process process, ApplicationContext ctx) {
        Integer prio = 5;
        try {
            String prioValue = (String)process.getProperties().get("priority");
            if (prioValue == null) {
                prioValue = "normal";
            }
            if (PRIORITY_NAMES.containsKey(prioValue)) {
                prioValue = PRIORITY_NAMES.get(prioValue).toString();
            }
            prio = new Integer(prioValue);
        }
        catch (Exception e) {
            prio = 5;
        }
        if (prio > 10) {
            prio = 10;
        }
        if (prio < 1) {
            prio = 1;
        }
        this.setPriority(prio);
        this.process = process;
        this.context = ctx;
    }

    public void addListener(ProcessListener l) {
        this.processListener.add(l);
    }

    public void removeListener(ProcessListener l) {
        this.processListener.remove(l);
    }

    public boolean isRunning() {
        return this.running;
    }

    public Process getProcess() {
        return this.process;
    }

    public void init() throws Exception {
        log.debug("Initializing process with process-context...");
        this.process.init(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            this.running = true;
            Exception error = null;
            try {
                log.debug("Starting process {}, notifying listeners {}", (Object)this.process, this.processListener);
                for (ProcessListener l : this.processListener) {
                    log.debug("Calling process-listener {}", (Object)l);
                    l.processStarted(this.process);
                }
                this.executing.set(true);
                this.process.execute();
                this.executing.set(false);
            }
            catch (InterruptedException ie) {
                log.error("Process thread interruped while executing!?");
                ie.printStackTrace();
                this.executing.set(false);
                error = ie;
            }
            catch (Exception e) {
                error = e;
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String exceptionDetails = sw.toString();
                log.error(exceptionDetails);
                for (ProcessListener l : this.processListener) {
                    log.debug("Calling process-listener {} for error handling", (Object)l);
                    l.processError(this.process, e);
                }
            }
            finally {
                this.executing.set(false);
                log.debug("ProcessThread shutting down...");
                try {
                    log.debug("Finishing processors...");
                    this.process.finish();
                }
                catch (Exception e) {
                    log.error("Failed to finish: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
                log.debug("Process {} finished, notifying listeners: {}", (Object)this.process, this.processListener);
                for (ProcessListener l : this.processListener) {
                    log.debug(" Calling listener {}", (Object)l);
                    l.processFinished(this.process);
                }
                this.running = false;
                if (error == null) break block18;
                throw new RuntimeException("Process stopped after exception: " + error.getMessage(), error.getCause());
            }
        }
    }

    public void signal(int flags) {
        log.debug("Signaling ProcessThread {}", (Object)this);
        if (this.executing.get()) {
            log.debug("   process thread is executing, sending interrupt() signal");
            this.interrupt();
        }
    }

    static {
        PRIORITY_NAMES.put("lowest", 1);
        PRIORITY_NAMES.put("low", 2);
        PRIORITY_NAMES.put("normal", 5);
        PRIORITY_NAMES.put("high", 7);
        PRIORITY_NAMES.put("highest", 10);
    }
}

