/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.ProcessContext;
import stream.runtime.ApplicationContext;
import stream.runtime.ContainerContext;
import stream.runtime.LocalContext;
import stream.service.NamingService;
import stream.service.Service;
import stream.service.ServiceInfo;

public class ProcessContextImpl
implements ProcessContext {
    static Logger log = LoggerFactory.getLogger(ProcessContextImpl.class);
    final ApplicationContext containerContext;
    final Map<String, Object> context = new HashMap<String, Object>();
    String processId;

    public ProcessContextImpl() {
        this(UUID.randomUUID().toString());
    }

    public ProcessContextImpl(String id) {
        this.processId = id;
        this.containerContext = new LocalContext();
    }

    public ProcessContextImpl(String id, ApplicationContext ctx) {
        this.processId = id;
        this.containerContext = ctx;
    }

    public ProcessContextImpl(String id, ContainerContext ctx) {
        this.processId = id;
        this.containerContext = ctx;
        log.debug("Creating new ProcessContext, parent context is {}", (Object)ctx);
    }

    public void register(String ref, Service p) throws Exception {
        if (this.containerContext == null) {
            throw new Exception("No parent context exists!");
        }
        this.containerContext.register(ref, p);
    }

    public void unregister(String ref) throws Exception {
        if (this.containerContext == null) {
            throw new Exception("No parent context exists!");
        }
        this.containerContext.unregister(ref);
    }

    public Map<String, ServiceInfo> list() throws Exception {
        return this.containerContext.list();
    }

    public Object get(String key) {
        return this.context.get(key);
    }

    public void set(String key, Object o) {
        this.context.put(key, o);
    }

    public Object resolve(String variable) {
        if (!variable.startsWith("process.")) {
            if (this.containerContext == null) {
                return null;
            }
            log.debug("resolving '{}' with parent context {}", (Object)variable, (Object)this.containerContext);
            return this.containerContext.resolve(variable);
        }
        return this.get(variable.substring("process.".length()));
    }

    public void addContainer(String key, NamingService remoteNamingService) throws Exception {
        throw new Exception("Addition of remote naming services is not supported by local context!");
    }

    public void clear() {
        this.context.clear();
    }

    public boolean contains(String key) {
        return this.context.containsKey(key);
    }

    public String getId() {
        return this.processId;
    }

    public Context getParent() {
        return this.containerContext;
    }

    public String path() {
        if (this.getParent() != null) {
            return this.getParent().path() + "/" + "process:" + this.getId();
        }
        return "process:" + this.getId();
    }
}

