/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.runtime.ApplicationContext;
import stream.runtime.DefaultProcess;
import stream.util.parser.TimeParser;

public class Monitor
extends DefaultProcess {
    static Logger log = LoggerFactory.getLogger(Monitor.class);
    private Long interval = 1000L;
    private String intervalString = "1000ms";
    private Long limit = -1L;

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public String getInterval() {
        return this.intervalString;
    }

    public void setInterval(String intervalString) {
        this.intervalString = intervalString;
    }

    @Override
    public void init(ApplicationContext context) throws Exception {
        super.init(context);
        try {
            this.interval = TimeParser.parseTime((String)this.getInterval());
            log.debug("Monitor-interval is {} ms", (Object)this.interval);
            this.source = new MonitorStream();
        }
        catch (Exception e) {
            this.interval = 1000L;
            throw new Exception("Failed to initialize Monitor: " + e.getMessage());
        }
    }

    @Override
    public Data process(Data item) {
        Data data = super.process(item);
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException e) {
            log.debug("Monitor finished.");
            return data;
        }
        return data;
    }

    @Override
    public String toString() {
        return "Monitor[" + super.toString() + "]";
    }

    public class MonitorStream
    extends AbstractStream {
        public Data readNext() throws Exception {
            return DataFactory.create();
        }
    }
}

