/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Process;
import stream.annotations.Service;
import stream.io.DefaultBlockingQueue;
import stream.io.PartitionedStream;
import stream.io.Queue;
import stream.io.Sink;
import stream.io.Source;
import stream.io.Stream;
import stream.runtime.setup.ParameterInjection;
import stream.service.NamingService;
import streams.application.ComputeGraph;
import streams.application.Reference;

public class DependencyInjection {
    static Logger log = LoggerFactory.getLogger(DependencyInjection.class);
    static final boolean PARTITIONED_STREAMS = "true".equalsIgnoreCase(System.getProperty("partitioned-streams", "false"));
    final List<Reference> refs = new ArrayList<Reference>();
    final Map<String, List<String>> remapping = new LinkedHashMap<String, List<String>>();

    public void add(Reference ref) {
        log.debug("Adding reference  {} -> {}", ref.object(), (Object)ref.ids());
        this.refs.add(ref);
    }

    public void addAll(Collection<Reference> refs) {
        this.refs.addAll(refs);
    }

    protected boolean hasPartitions(String streamId) {
        return this.remapping.containsKey(streamId);
    }

    protected String getNextPartition(String streamId) {
        List<String> partitions = this.remapping.get(streamId);
        if (partitions == null) {
            return streamId;
        }
        if (partitions.isEmpty()) {
            return "_no_more_partitions_left_";
        }
        String part = partitions.remove(0);
        log.info("  {} ~> {}", (Object)streamId, (Object)part);
        return part;
    }

    public void injectDependencies(ComputeGraph graph, NamingService namingService) throws Exception {
        log.debug("Found {} references to be resolved...", this.refs);
        LinkedHashMap streamPartitions = new LinkedHashMap();
        for (Object s : graph.getAll(Stream.class)) {
            Stream stream = (Stream)s;
            String sid = stream.getId();
            if (PARTITIONED_STREAMS && s instanceof PartitionedStream) {
                log.info("<EXPERIMENTAL>");
                log.info("Assigning partitioned streams to multiple copies (sub-stream - consumer mapping)");
                PartitionedStream ms = (PartitionedStream)s;
                ms.init();
                log.info("Found partitioned-stream {}", (Object)ms);
                Map sub = ms.partitions();
                ArrayList<String> parts = new ArrayList<String>();
                for (String id : sub.keySet()) {
                    streamPartitions.put(sid + ":" + id, sub.get(id));
                    parts.add(sid + ":" + id);
                }
                this.remapping.put(sid, parts);
                log.info("</EXPERIMENTAL>");
                continue;
            }
            log.debug("Object {} is not a partitioned-stream", s);
            streamPartitions.put(sid, stream);
        }
        log.debug("Stream partitions are:");
        for (String id : streamPartitions.keySet()) {
            log.debug("  {}  ->   {}", (Object)id, streamPartitions.get(id));
        }
        log.debug("graph has {} streams, {} processes", (Object)graph.getAll(Stream.class).size(), (Object)graph.getAll(Process.class).size());
        Iterator<Reference> it = this.refs.iterator();
        while (it.hasNext()) {
            Reference ref = it.next();
            log.debug("next unresolved reference is {}", (Object)ref);
            boolean success = this.inject(ref, graph, namingService);
            if (success) {
                log.debug("Successfully injected dependency {}", (Object)ref);
                it.remove();
                continue;
            }
            log.error("Failed to resolve dependency {}", (Object)ref);
        }
        if (!this.refs.isEmpty()) {
            throw new Exception(this.refs.size() + " unresolved dependencies!");
        }
    }

    private boolean inject(Reference ref, ComputeGraph graph, NamingService namingService) throws Exception {
        if (ref instanceof ComputeGraph.SinkRef) {
            return this.inject((ComputeGraph.SinkRef)ref, graph);
        }
        if (ref instanceof ComputeGraph.SourceRef) {
            return this.inject((ComputeGraph.SourceRef)ref, graph);
        }
        if (ref instanceof ComputeGraph.ServiceRef) {
            return this.inject((ComputeGraph.ServiceRef)ref, graph, namingService);
        }
        return false;
    }

    private boolean inject(ComputeGraph.SinkRef ref, ComputeGraph graph) throws Exception {
        log.debug("Injecting sink reference {}", (Object)ref);
        String[] refs = ref.ids();
        Object[] sinks = new Sink[refs.length];
        for (int i = 0; i < sinks.length; ++i) {
            sinks[i] = (Sink)graph.sinks().get(refs[i]);
            if (sinks[i] == null) {
                DefaultBlockingQueue queue = new DefaultBlockingQueue();
                queue.setId(refs[i]);
                graph.addQueue(refs[i], (Queue)queue);
                if (queue instanceof stream.service.Service) {
                    graph.addService(refs[i], (stream.service.Service)queue);
                }
                log.debug("Creating implicitly defined queue: {}", (Object)queue);
                sinks[i] = queue;
            }
            log.debug("EDGE:  Adding {} -> {}", ref.object(), sinks[i]);
            graph.add(ref.object(), sinks[i]);
        }
        return this.injectResolvedReferences(ref.object(), ref.property(), sinks);
    }

    private boolean inject(ComputeGraph.SourceRef ref, ComputeGraph graph) throws Exception {
        log.debug("Injecting source reference {}", (Object)ref);
        String[] refs = ref.ids();
        Object[] sources = new Source[refs.length];
        for (int i = 0; i < sources.length; ++i) {
            log.debug("resolving source[{}] ~>  refs[{}] = {}", new Object[]{i, i, refs[i]});
            sources[i] = (Source)graph.sources().get(refs[i]);
            if (sources[i] == null) {
                DefaultBlockingQueue queue = new DefaultBlockingQueue();
                queue.setId(refs[i]);
                graph.addQueue(refs[i], (Queue)queue);
                if (queue instanceof stream.service.Service) {
                    graph.addService(refs[i], (stream.service.Service)queue);
                }
                log.debug("Created new Queue:{} {}", (Object)queue.getId(), (Object)queue);
                sources[i] = queue;
            }
            if (sources[i] instanceof PartitionedStream) {
                log.info("resoling multi-stream reference   {}  ->  {} ", sources[i], ref.object());
                String part = this.getNextPartition(refs[i]);
                log.info("   re-mapping:   {}  =>  {}", (Object)refs[i], (Object)part);
                PartitionedStream ms = (PartitionedStream)sources[i];
                log.info("parts:  {}", ms.partitions().keySet());
                String id = part.substring(refs[i].length() + 1);
                Stream stream = (Stream)ms.partitions().get(id);
                log.info("   re-assigning  {}.input  ~> {} ", ref.object(), (Object)stream);
                sources[i] = stream;
            }
            graph.add(sources[i], ref.object());
        }
        return this.injectResolvedReferences(ref.object(), ref.property(), sources);
    }

    private boolean inject(ComputeGraph.ServiceRef ref, ComputeGraph graph, NamingService namingService) throws Exception {
        log.debug("Injecting service reference {}", (Object)ref);
        String[] refs = ref.ids();
        Object[] services = new stream.service.Service[refs.length];
        for (int i = 0; i < services.length; ++i) {
            services[i] = namingService.lookup(refs[i], ref.type());
            if (services[i] != null) continue;
            log.error("Referenced service '{}' not found!", (Object)refs[i]);
            String obj = ref.object() + "";
            if (ref.object() != null) {
                obj = ref.object().getClass().getName();
            }
            throw new Exception("Service '" + refs[i] + "' referenced by " + obj + " can not be found!");
        }
        return this.injectResolvedReferences(ref.object(), ref.property(), services);
    }

    public boolean injectResolvedReferences(Object o, String property, Object[] resolvedRefs) throws Exception {
        for (Field field : o.getClass().getDeclaredFields()) {
            if (!DependencyInjection.isServiceImplementation(field.getType())) continue;
            log.debug("Checking service-field {}", (Object)field.getName());
            String prop = field.getName();
            Service sa = field.getAnnotation(Service.class);
            if (sa != null && !sa.name().isEmpty()) {
                prop = sa.name();
            }
            log.debug("Service field '{}' relates to property '{}'", (Object)field.getName(), (Object)prop);
            if (!prop.equals(property)) continue;
            if (field.getType().isArray()) {
                Class<?> valueType = field.getType().getComponentType();
                if (valueType.isAssignableFrom(resolvedRefs.getClass().getComponentType())) {
                    boolean orig = field.isAccessible();
                    field.setAccessible(true);
                    field.set(o, resolvedRefs);
                    field.setAccessible(orig);
                    return true;
                }
                throw new Exception("Array type mis-match! Field '" + field.getName() + "' of type " + field.getType().getComponentType() + "[] is not assignable from " + resolvedRefs.getClass().getComponentType() + "[]!");
            }
            Class<?> valueType = field.getType();
            if (valueType.isAssignableFrom(resolvedRefs[0].getClass())) {
                boolean orig = field.isAccessible();
                field.setAccessible(true);
                field.set(o, resolvedRefs[0]);
                field.setAccessible(orig);
                return true;
            }
            throw new Exception("Field '" + field.getName() + "' is not assignable with object of type " + resolvedRefs[0].getClass());
        }
        String name = "set" + property.toLowerCase();
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().toLowerCase().equalsIgnoreCase(name) || m.getParameterTypes().length != 1) continue;
            Class<?> type = m.getParameterTypes()[0];
            if (type.isArray()) {
                Object values = Array.newInstance(type.getComponentType(), resolvedRefs.length);
                for (int i = 0; i < Array.getLength(values); ++i) {
                    Array.set(values, i, resolvedRefs[i]);
                }
                log.debug("Injecting   '{}'.{}   <-- " + values, o, (Object)property);
                log.debug("Calling method  '{}'", (Object)m);
                m.invoke(o, values);
            } else {
                log.debug("Injecting   '{}'.{}   <-- " + resolvedRefs[0], o, (Object)property);
                log.debug("Calling method  '{}' with arg '{}'", (Object)m, resolvedRefs[0]);
                m.invoke(o, resolvedRefs[0]);
            }
            return true;
        }
        return false;
    }

    public static Class<? extends Sink> hasSinkSetter(String name, Object o) {
        for (Method m : o.getClass().getMethods()) {
            if (!m.getName().toLowerCase().equals("set" + name) || !ParameterInjection.isQueueSetter(m)) continue;
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public static Class<? extends stream.service.Service> hasServiceSetter(String name, Object o) {
        try {
            for (Method m : o.getClass().getMethods()) {
                Class<?>[] types;
                if (!m.getName().equalsIgnoreCase("set" + name) || !DependencyInjection.isServiceSetter(m) || (types = m.getParameterTypes()).length <= 0) continue;
                return m.getParameterTypes()[0];
            }
            return null;
        }
        catch (Exception e) {
            log.error("Failed to determine service-setter: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isServiceSetter(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        return DependencyInjection.isServiceImplementation(paramTypes[0]);
    }

    public static boolean isSourceSetter(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        return Source.class.isAssignableFrom(paramTypes[0]);
    }

    public static boolean isSinkSetter(Method m) {
        return DependencyInjection.isSetter(m, Sink.class);
    }

    public static boolean isSinkArraySetter(Method m) {
        return DependencyInjection.isArraySetter(m, Sink.class);
    }

    public static boolean isSetter(Method m, Class<?> type) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length != 1) {
            return false;
        }
        if (paramTypes[0].isArray()) {
            return type.isAssignableFrom(paramTypes[0].getComponentType());
        }
        return type.isAssignableFrom(paramTypes[0]);
    }

    public static boolean isArraySetter(Method m, Class<?> type) {
        if (DependencyInjection.isSetter(m, type)) {
            return m.getParameterTypes()[0].isArray();
        }
        return false;
    }

    public static boolean isServiceImplementation(Class<?> clazz) {
        return stream.service.Service.class.isAssignableFrom(clazz);
    }
}

