/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.ProcessContainer;
import stream.runtime.StreamRuntime;
import stream.util.Variables;

public class Container
implements Callable<Boolean> {
    private URL url;
    private Map<String, String> args;
    static Logger log = LoggerFactory.getLogger(Container.class);
    private ProcessContainer container;

    public Container(URL url) {
        this.url = url;
    }

    public Container(URL url, Map<String, String> args) {
        this(url);
        this.args = args;
    }

    @Override
    public Boolean call() throws Exception {
        Variables props = StreamRuntime.loadUserProperties();
        if (props == null) {
            props = new Variables();
        }
        if (this.args != null) {
            props.addVariables(this.args);
        }
        log.debug("Creating process-container from configuration at {}", (Object)this.url);
        this.container = new ProcessContainer(this.url, null, (Map<String, String>)props);
        log.info("Starting process-container...");
        this.container.run();
        log.info("Container started.");
        return true;
    }

    public void shutdown() {
        this.container.shutdown();
    }
}

