/*
 * Decompiled with CFR 0.152.
 */
package stream.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.annotations.Internal;
import stream.doc.ClassFinder;
import stream.doc.DocFinder;
import stream.doc.DocGenerator;
import stream.io.Stream;
import stream.util.WildcardPattern;

public class DocTree
implements Comparable<DocTree> {
    static Logger log = LoggerFactory.getLogger(DocTree.class);
    DocTree parent = null;
    String prefix = "API_";
    final String name;
    final SortedSet<DocTree> children = new TreeSet<DocTree>();

    public DocTree(String pkg) {
        this.name = pkg;
    }

    public void add(DocTree child) {
        this.children.add(child);
        child.parent = this;
    }

    public Set<DocTree> getChildren() {
        return this.children;
    }

    public void add(String[] path, DocTree child) {
        if (path.length > 1) {
            String[] remain = new String[path.length - 1];
            for (int i = 1; i < path.length; ++i) {
                remain[i - 1] = path[i];
            }
            this.getChild(path[0]).add(remain, child);
        } else {
            this.getChild(path[0]).add(child);
        }
    }

    public DocTree getChild(String n) {
        for (DocTree ch : this.children) {
            if (!ch.name.equals(n)) continue;
            return ch;
        }
        DocTree nch = new DocTree(n);
        nch.parent = this;
        this.children.add(nch);
        return nch;
    }

    public boolean hasChild(String name) {
        for (DocTree ch : this.children) {
            if (!name.equals(ch.name)) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public int compareTo(DocTree arg0) {
        if (arg0 == null) {
            return 1;
        }
        if (this == arg0) {
            return 0;
        }
        return this.name.compareTo(arg0.name);
    }

    public void print(String prefix) {
        System.out.print(prefix + " | " + this.name + "\n");
        for (DocTree ch : this.children) {
            ch.print(prefix + "  ");
        }
    }

    public String getPath() {
        if (this.parent == null) {
            return "";
        }
        if (this.isLeaf()) {
            return this.parent.getPath();
        }
        return this.parent.getPath() + "/" + this.name;
    }

    public List<File> generateDocs(File base) throws IOException {
        ArrayList<File> indexFiles = new ArrayList<File>();
        if (!this.isLeaf()) {
            URL texUrl;
            String p = this.getPath();
            if (!p.isEmpty()) {
                p = p.substring(1);
            }
            p = p.replace('/', '_') + "_index.tex";
            while (p.startsWith("_")) {
                p = p.substring(1);
            }
            File indexTex = new File(base.getAbsolutePath() + "/" + this.prefix + p);
            indexTex.getParentFile().mkdirs();
            PrintStream out = new PrintStream(new FileOutputStream(indexTex));
            indexFiles.add(indexTex);
            URL url = DocTree.class.getResource(this.getPath() + "/index.md");
            try {
                texUrl = DocTree.class.getResource(this.getPath() + "/index.tex");
                log.info("index.tex for path {} is: {}", (Object)this.getPath(), (Object)texUrl);
                if (texUrl != null) {
                    DocGenerator.copy(texUrl.openStream(), out);
                    out.println();
                    out.println();
                    out.println();
                } else if (url != null) {
                    DocGenerator.converter.convert(url.openStream(), out);
                    out.println();
                    out.println();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            indexTex.getParentFile().mkdirs();
            ArrayList<DocTree> list = new ArrayList<DocTree>(this.children);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                DocTree ch = (DocTree)it.next();
                URL docUrl = DocTree.class.getResource(ch.getPath() + "/" + ch.name);
                texUrl = DocTree.class.getResource(ch.getPath() + "/" + ch.name.replace(".md", ".tex"));
                if (docUrl != null || texUrl != null) continue;
                log.debug("Not linking non-existing document url for {}", (Object)(ch.getPath() + "/" + ch.name));
                it.remove();
            }
            DocGenerator.converter.createTableOfContents(list, out);
            out.close();
            DocGenerator.converter.sectionDown();
            for (DocTree ch : this.children) {
                List<File> indexes = ch.generateDocs(base);
                indexFiles.addAll(indexes);
            }
            DocGenerator.converter.sectionUp();
        } else {
            String path = this.getPath();
            if (path.trim().isEmpty()) {
                return indexFiles;
            }
            log.info("Converting doc-tree leaf '{}'", (Object)(path + "/" + this.name));
            File md = new File(base.getAbsolutePath() + File.separator + this.prefix + this.getPath().substring(1).replace('/', '_') + "_" + this.name);
            log.info("   to {}", (Object)md);
            this.generateTex(md);
        }
        return indexFiles;
    }

    public String getResourceName(String ext) {
        return "/" + this.getPath() + "/" + this.name.replace(".md", ext);
    }

    private File generateTex(File md) {
        URL url;
        File tex = new File(md.getAbsolutePath().replace(".md", ".tex"));
        String className = this.getPath().substring(1).replace('/', '.') + "." + this.name.replace(".md", "");
        String texResource = this.getPath() + "/" + this.name.replace(".md", ".tex");
        URL texUrl = DocFinder.class.getResource(texResource);
        log.debug("checking for .tex file at {} => {}", (Object)texResource, (Object)texUrl);
        if (texUrl != null) {
            log.debug("Found existing .tex documentation!");
            try {
                FileOutputStream fos = new FileOutputStream(tex);
                PrintStream out = new PrintStream(fos);
                Class<?> clazz = Class.forName(className);
                if (DocFinder.implementsInterface(clazz, Stream.class)) {
                    out.println("\\Stream{" + clazz.getSimpleName() + "}");
                    out.println("\\label{sec:" + clazz.getCanonicalName() + "}\n");
                }
                if (DocFinder.implementsInterface(clazz, Processor.class)) {
                    out.println("\\Processor{" + clazz.getSimpleName() + "}");
                    out.println("\\label{sec:" + clazz.getCanonicalName() + "}\n");
                }
                DocGenerator.copy(texUrl.openStream(), fos);
                out.println();
                DocGenerator.converter.writeParameterTable(clazz, out);
                out.flush();
                fos.close();
                return tex;
            }
            catch (Exception e) {
                log.error("Error: {}", (Object)e.getMessage());
            }
        }
        if ((url = DocFinder.class.getResource(this.getPath() + "/" + this.name)) == null) {
            log.error("No documentation found for '{}'", (Object)className);
            return null;
        }
        try {
            log.debug("Converting {} to {}", (Object)url, (Object)tex);
            FileOutputStream fos = new FileOutputStream(tex);
            PrintStream pos = new PrintStream(fos);
            DocGenerator.converter.convert(url.openStream(), pos);
            DocGenerator.converter.writeParameterTable(Class.forName(className), pos);
            pos.flush();
            pos.close();
        }
        catch (Exception e) {
            log.error("Error: {}", (Object)e.getMessage());
        }
        return tex;
    }

    public static boolean matches(String[] patterns, Class<?> clazz) {
        if (patterns == null || patterns.length == 0) {
            return true;
        }
        String className = clazz.getCanonicalName();
        if (className == null) {
            return false;
        }
        for (String pattern : patterns) {
            if (className.startsWith(pattern)) {
                log.debug("Class '{}' starts with pattern {}", (Object)className, (Object)pattern);
                return true;
            }
            if (!WildcardPattern.matches((String)pattern, (String)className)) continue;
            return true;
        }
        log.debug("No match for class '{}' and patterns {}", (Object)className, (Object)patterns);
        return false;
    }

    public static DocTree findDocs(Class<?>[] CLASSES, String[] patterns) {
        DocTree tree = new DocTree("");
        try {
            ArrayList classes = new ArrayList();
            for (String string : patterns) {
                classes.addAll(ClassFinder.getClasses(string));
            }
            TreeSet<String> docs = new TreeSet<String>();
            TreeSet<String> missing = new TreeSet<String>();
            block3: for (Class clazz : classes) {
                if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) continue;
                if (clazz.isAnnotationPresent(Internal.class)) {
                    log.debug("Skipping internal class {}", (Object)clazz);
                    continue;
                }
                for (Class<?> apiClass : CLASSES) {
                    if (!apiClass.isAssignableFrom(clazz)) continue;
                    if (clazz.isAnnotationPresent(Deprecated.class)) {
                        log.debug("Skipping deprecated class {}", (Object)clazz);
                        continue block3;
                    }
                    if (DocTree.matches(patterns, clazz)) {
                        log.debug("Found processor-class {}", (Object)clazz);
                        log.debug("    clazz.getName() = {}", (Object)clazz.getName());
                        String doc = "/" + clazz.getName().replace('.', '/') + ".md";
                        log.debug("    docs are at {}", (Object)doc);
                        int idx = doc.substring(1).lastIndexOf("/");
                        String[] path = doc.substring(1, idx + 1).split("/");
                        DocTree elem = new DocTree(doc.substring(idx + 2));
                        tree.add(path, elem);
                        URL url = DocTree.getMarkDownFile(clazz);
                        URL texUrl = DocTree.getTexFile(clazz);
                        if (texUrl != null) {
                            url = texUrl;
                            doc = doc.replace(".md", ".tex");
                        }
                        if (url != null) {
                            docs.add(doc);
                            continue;
                        }
                        missing.add(doc);
                        continue;
                    }
                    log.debug("Skipping class '{}' due to patterns {}", (Object)clazz, (Object)patterns);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tree;
    }

    public static URL getMarkDownFile(Class<?> clazz) {
        String doc = "/" + clazz.getName().replace('.', '/') + ".md";
        log.debug("Checking for markdown file at '{}'", (Object)doc);
        return DocTree.class.getResource(doc);
    }

    public static URL getTexFile(Class<?> clazz) {
        String doc = "/" + clazz.getName().replace('.', '/') + ".tex";
        log.debug("Checking for TeX file at '{}'", (Object)doc);
        return DocTree.class.getResource(doc);
    }
}

