/*
 * Decompiled with CFR 0.152.
 */
package stream.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFinder {
    static Logger log = LoggerFactory.getLogger(ClassFinder.class);

    public static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        return ClassFinder.getClasses(packageName, ClassFinder.class.getClassLoader());
    }

    public static Class<?>[] getClasses(String packageName, ClassLoader loader) throws ClassNotFoundException, IOException {
        ArrayList classes = new ArrayList();
        ClassLoader classLoader = loader;
        log.debug("Using class-loader {}", (Object)classLoader);
        assert (classLoader != null);
        ArrayList<URL> resources = new ArrayList<URL>();
        String path = packageName.replace('.', '/');
        Enumeration<URL> urlList = classLoader.getResources(path);
        while (urlList.hasMoreElements()) {
            resources.add(urlList.nextElement());
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)classLoader;
            Iterator iterator = null;
            try {
                URL[] urls = ucl.getURLs();
                if (urls != null) {
                    for (URL url : urls) {
                        log.debug("Adding URL {} from URLClassLoader", (Object)url);
                        resources.add(url);
                    }
                }
            }
            catch (Throwable urls) {
                iterator = urls;
                throw urls;
            }
            finally {
                if (ucl != null) {
                    if (iterator != null) {
                        try {
                            ucl.close();
                        }
                        catch (Throwable urls) {
                            ((Throwable)((Object)iterator)).addSuppressed(urls);
                        }
                    } else {
                        ucl.close();
                    }
                }
            }
        }
        ArrayList<File> dirs = new ArrayList<File>();
        for (URL resource : resources) {
            if (resource.toString().startsWith("jar:") || resource.toExternalForm().endsWith(".jar")) {
                log.debug("Scanning jar-file {}", (Object)resource.getPath());
                String p = resource.getPath();
                if (p.indexOf("!") > 0) {
                    p = p.substring(0, p.indexOf("!"));
                    log.trace("Opening jar '{}'", (Object)p);
                }
                if (p.startsWith("file:")) {
                    p = p.substring("file:".length());
                }
                classes.addAll(ClassFinder.findClasses(new JarFile(p), packageName, loader));
                continue;
            }
            log.trace("Checking URL {}", (Object)resource);
            dirs.add(new File(resource.getFile()));
        }
        for (File directory : dirs) {
            List<Class<?>> cl = ClassFinder.findClasses(directory, packageName);
            log.debug("Found {} classes in {}", (Object)cl.size(), (Object)directory);
            classes.addAll(cl);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static List<Class<?>> findClasses(JarFile jar, String packageName) throws ClassNotFoundException {
        return ClassFinder.findClasses(jar, packageName, ClassFinder.class.getClassLoader());
    }

    public static List<Class<?>> findClasses(JarFile jar, String packageName, ClassLoader loader) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        log.debug("Checking jar-file {}", (Object)jar.getName());
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            entry.getName();
            log.debug("Checking JarEntry '{}'", (Object)entry.getName());
            if (!entry.getName().endsWith(".class") || entry.getName().startsWith("com.rapidminer") || !entry.getName().replaceAll("/", ".").startsWith(packageName)) continue;
            try {
                String className = entry.getName().replaceAll("\\.class$", "").replace('/', '.');
                log.trace("Class-name is: '{}'", (Object)className);
                Class<?> clazz = Class.forName(className);
                log.trace("Found class {}", clazz);
                classes.add(clazz);
            }
            catch (VerifyError className) {
            }
            catch (NoClassDefFoundError className) {
            }
            catch (ClassNotFoundException className) {
            }
            catch (Exception e) {
                log.error("Failed to load class for entry '{}'", (Object)entry.getName());
            }
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        if (packageName.startsWith("com.rapidminer")) {
            return new ArrayList();
        }
        log.debug("Searching directory '{}' for package '{}'", (Object)directory, (Object)packageName);
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return classes;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                if (packageName.isEmpty()) {
                    classes.addAll(ClassFinder.findClasses(file, file.getName()));
                    continue;
                }
                classes.addAll(ClassFinder.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            try {
                String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
                while (className.startsWith(".")) {
                    className = className.substring(1);
                }
                log.debug("Loading class '{}'", (Object)className);
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException className) {
            }
            catch (NoClassDefFoundError className) {
            }
            catch (Exception e) {
                log.error("Failed to add class: {}", (Object)e.getMessage());
            }
        }
        return classes;
    }
}

