/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ConditionedProcessor;
import stream.Context;
import stream.Data;
import stream.ProcessContext;
import stream.data.Statistics;
import stream.expressions.ExpressionResolver;
import stream.statistics.History;
import stream.statistics.StatisticsService;
import stream.util.parser.TimeParser;

public class Count
extends ConditionedProcessor
implements StatisticsService {
    static Logger log = LoggerFactory.getLogger(Count.class);
    String groupBy = null;
    String timeKey = null;
    String prefix = null;
    String window = "5 minutes";
    Long timeInterval = 300000L;
    String history = "1 day";
    Long timeWindow = this.timeInterval * 12L * 24L;
    String timeFormat = null;
    History<Statistics> historyStats;
    String file = null;
    Long lastTime = 0L;
    final Statistics currentStatistics = new Statistics();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data processMatchingData(Data input) {
        if (this.groupBy == null) {
            return input;
        }
        try {
            String pivot = ExpressionResolver.expand((String)this.groupBy, (Context)this.context, (Data)input);
            Long time = System.currentTimeMillis();
            if (this.timeKey != null && input.containsKey((Object)this.timeKey)) {
                time = new Long(input.get((Object)this.timeKey) + "");
            }
            log.trace("time = {}", (Object)time);
            time = this.historyStats.mapTimestamp(time);
            log.debug("mapped time is: {} ({})", (Object)new Date(time), (Object)time);
            Statistics st = this.historyStats.get(time);
            if (st == null) {
                st = new Statistics();
                st.put((Object)"@time", (Object)time.doubleValue());
            }
            if (this.prefix != null) {
                st.add(this.prefix + pivot, Double.valueOf(1.0));
            } else {
                st.add(pivot, Double.valueOf(1.0));
            }
            this.historyStats.add(time, st);
            Statistics statistics = this.currentStatistics;
            synchronized (statistics) {
                this.currentStatistics.add(st);
            }
            if (this.lastTime == 0L) {
                this.lastTime = time;
            }
            if (!time.equals(this.lastTime)) {
                log.debug("new time-index, putting out all statistics {}", (Object)st);
                input.putAll((Map)st);
                statistics = this.currentStatistics;
                synchronized (statistics) {
                    for (String key : this.currentStatistics.keySet()) {
                        this.currentStatistics.put((Object)key, (Object)new Double(0.0));
                    }
                }
                this.lastTime = time;
            } else {
                log.debug(" lastTime != time  ( {} != {} )", (Object)this.lastTime, (Object)time);
            }
            return input;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.timeWindow = TimeParser.parseTime((String)this.history);
        this.timeInterval = TimeParser.parseTime((String)this.window);
        log.debug("Aggregating in intervals of {} ms, keeping {} ms of history", (Object)this.timeInterval, (Object)this.timeWindow);
        this.historyStats = new History(this.timeInterval, this.timeWindow);
        if (this.timeFormat != null) {
            new SimpleDateFormat(this.timeFormat);
        }
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String channelKey) {
        this.groupBy = channelKey;
    }

    public String getTimeKey() {
        return this.timeKey;
    }

    public void setTimeKey(String timeKey) {
        this.timeKey = timeKey;
    }

    public String getHistory() {
        return this.history;
    }

    public void setHistory(String window) {
        this.history = window;
    }

    public String getWindow() {
        return this.window;
    }

    public void setWindow(String interval) {
        this.window = interval;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws Exception {
        Statistics statistics = this.currentStatistics;
        synchronized (statistics) {
            this.currentStatistics.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics getStatistics() {
        Statistics statistics = this.currentStatistics;
        synchronized (statistics) {
            log.debug("Returning copy of statistics {}", (Object)this.currentStatistics);
            Long time = this.historyStats.mapTimestamp(System.currentTimeMillis());
            Statistics st = this.historyStats.get(time);
            if (st != null) {
                return new Statistics(this.historyStats.get(time));
            }
            return new Statistics();
        }
    }
}

