/*
 * Decompiled with CFR 0.152.
 */
package stream.parser;

import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Parameter;
import stream.util.parser.Parser;
import stream.util.parser.ParserGenerator;

public class ParseString
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(ParseString.class);
    String key = null;
    String format = null;
    Parser<Map<String, String>> parser = null;

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The key of the attribute which contains the string that is to be parsed.")
    public void setKey(String key) {
        this.key = key;
    }

    public String getFormat() {
        return this.format;
    }

    @Parameter(description="The grammar string to create the parser from.")
    public void setFormat(String format) {
        this.format = format;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this.format != null) {
            ParserGenerator pg = new ParserGenerator(this.format);
            this.parser = pg.newParser();
        }
    }

    public Data process(Data input) {
        block5: {
            if (this.parser == null || input == null) {
                return input;
            }
            if (this.key != null && input.containsKey((Object)this.key)) {
                String value = null;
                try {
                    value = ((Serializable)input.get((Object)this.key)).toString();
                    Map vals = (Map)this.parser.parse(value);
                    for (String k : vals.keySet()) {
                        input.put((Object)k, vals.get(k));
                    }
                }
                catch (Exception e) {
                    log.error("Failed to parse string '{}', error: {}", (Object)value, (Object)e.getMessage());
                    if (!log.isDebugEnabled()) break block5;
                    e.printStackTrace();
                }
            }
        }
        return input;
    }
}

