/*
 * Decompiled with CFR 0.152.
 */
package stream.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.net.Connection;

public class ConnectionHandler
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    protected boolean running = true;
    protected ServerSocket connectionSocket;
    private final ExecutorService pool;
    protected int port;
    protected int bufferSize;
    protected boolean gzip;
    protected boolean disconnectSlowClients;
    protected final List<Connection> connections = new CopyOnWriteArrayList<Connection>();

    public ConnectionHandler(ExecutorService pool, ServerSocket connectionSocket) {
        this.pool = pool;
        this.connectionSocket = connectionSocket;
    }

    public void init(int bufferSize, boolean gzip, boolean disconnectSlowClients) throws IOException {
        this.bufferSize = bufferSize;
        this.gzip = gzip;
        this.disconnectSlowClients = disconnectSlowClients;
    }

    public void register(Socket socket, int bufferSize, boolean gzip, boolean disconnectSlowClients) throws IOException {
        Connection connection = new Connection(this);
        connection.init(socket, bufferSize, gzip, disconnectSlowClients);
        this.pool.execute(connection);
        this.connections.add(connection);
    }

    public void unregister(Connection connection) {
        this.connections.remove(connection);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.log.info("Starting TCP DataTap server on socket {}", (Object)this.connectionSocket);
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        socket = this.connectionSocket.accept();
                        this.register(socket, this.bufferSize, this.gzip, this.disconnectSlowClients);
                        this.log.info("New client connection accepted: {}", (Object)socket);
                    }
                }
                catch (SocketException e) {
                    this.log.warn(e.toString());
                }
                catch (Exception e) {
                    this.log.error("Unexpected exception in server thread:", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable var2_4) {
            this.close();
            throw var2_4;
        }
        ** GOTO lbl-1000
    }

    public void close() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void write(Data item) {
        for (Connection c : this.connections) {
            try {
                c.write(item);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

