/*
 * Decompiled with CFR 0.152.
 */
package stream.lookup;

import java.util.Map;
import stream.Data;
import stream.annotations.Parameter;
import stream.io.CsvStream;
import stream.io.SourceURL;
import stream.io.Stream;
import stream.lookup.AbstractDatabase;

public class CsvDatabase
extends AbstractDatabase {
    boolean header = true;
    String[] keys = null;
    String separator = "(;|,)";

    @Override
    protected void populateDatabase(SourceURL url, Map<String, Data> database) throws Exception {
        CsvStream stream = new CsvStream(url);
        stream.setHeader(this.isHeader());
        stream.setKeys(this.getKeys());
        stream.setSeparator(this.getSeparator());
        stream.init();
        this.readDatabase((Stream)stream, database);
        stream.close();
    }

    public boolean isHeader() {
        return this.header;
    }

    @Parameter(description="Whether to use the first line as headers (keys/attribute names). ", required=false)
    public void setHeader(boolean header) {
        this.header = header;
    }

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(description="The keys of the CSV file. If not specified, the first line of the CSV will be used as keys.", required=false)
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Parameter(description="The separator string used for the CSV stream reading.", required=false)
    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

