/*
 * Decompiled with CFR 0.152.
 */
package stream.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.ConditionedProcessor;
import stream.Context;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Description;
import stream.expressions.version2.StringExpression;

@Description(text="", group="Streams.Monitoring")
public class Message
extends ConditionedProcessor {
    static Logger log = LoggerFactory.getLogger(Message.class);
    protected String txt;
    protected String condition;
    protected String level = "debug";
    protected StringExpression filter;

    public void setMessage(String msg) {
        this.txt = msg == null ? "" : msg;
    }

    public String getMessage() {
        return this.txt;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.filter = new StringExpression(this.txt);
    }

    public Data processMatchingData(Data data) {
        try {
            switch (this.level) {
                case "debug": {
                    log.debug(this.filter.get((Context)this.context, data));
                    break;
                }
                case "info": {
                    log.info(this.filter.get((Context)this.context, data));
                    break;
                }
                case "trace": {
                    log.trace(this.filter.get((Context)this.context, data));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }
}

