/*
 * Decompiled with CFR 0.152.
 */
package stream.learner.evaluation;

public final class TableOfConfusion {
    private long truePositive;
    private long trueNegative;
    private long falsePositive;
    private long falseNegative;

    public void addTruePositive() {
        this.addTruePositive(1L);
    }

    public void addTruePositive(long delta) {
        this.truePositive += delta;
    }

    public void addTrueNegative() {
        this.addTrueNegative(1L);
    }

    public void addTrueNegative(long delta) {
        this.trueNegative += delta;
    }

    public void addFalsePositive() {
        this.addFalsePositive(1L);
    }

    public void addFalsePositive(long delta) {
        this.falsePositive += delta;
    }

    public void addFalseNegative() {
        this.addFalseNegative(1L);
    }

    public void addFalseNegative(long delta) {
        this.falseNegative += delta;
    }

    public double calculatePrecision() {
        long divisor = this.truePositive + this.falsePositive;
        if (divisor == 0L) {
            return 0.0;
        }
        return (double)this.truePositive / (double)divisor;
    }

    public double calculateRecall() {
        long divisor = this.truePositive + this.falseNegative;
        if (divisor == 0L) {
            return 0.0;
        }
        return (double)this.truePositive / (double)divisor;
    }

    public double calculateSpecificity() {
        long divisor = this.trueNegative + this.falsePositive;
        if (divisor == 0L) {
            return 0.0;
        }
        return (double)this.trueNegative / (double)divisor;
    }

    public double calculateAccuracy() {
        long divisor = this.truePositive + this.trueNegative + this.falsePositive + this.falseNegative;
        if (divisor == 0L) {
            return 0.0;
        }
        return (double)(this.truePositive + this.trueNegative) / (double)divisor;
    }

    public double calculateFScore() {
        double divisor = this.calculatePrecision() + this.calculateRecall();
        if (divisor == 0.0) {
            return 0.0;
        }
        return 2.0 * (this.calculatePrecision() * this.calculateRecall() / (this.calculatePrecision() + this.calculateRecall()));
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        String prec = this.calculatePrecision() + " (TN:" + this.trueNegative + " TP: " + this.truePositive + ")";
        String rec = this.calculateRecall() + " (TP: " + this.truePositive + ", TP+FN: " + (this.truePositive + this.falseNegative) + ")";
        return "TableOfConfusion" + lineSeparator + "precision:   " + prec + lineSeparator + "recall:      " + rec + lineSeparator + "specificity: " + this.calculateSpecificity() + lineSeparator + "accuracy:    " + this.calculateAccuracy() + lineSeparator + "fscore:      " + this.calculateFScore() + lineSeparator;
    }

    public String toStringOld() {
        String lineSeparator = System.getProperty("line.separator");
        return "TableOfConfusion" + lineSeparator + "precision:   " + this.calculatePrecision() + lineSeparator + "recall:      " + this.calculateRecall() + lineSeparator + "specificity: " + this.calculateSpecificity() + lineSeparator + "accuracy:    " + this.calculateAccuracy() + lineSeparator + "fscore:      " + this.calculateFScore() + lineSeparator;
    }
}

