/*
 * Decompiled with CFR 0.152.
 */
package stream.io.multi;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.Stream;
import stream.io.multi.AbstractMultiStream;

public class SequentialMultiStream
extends AbstractMultiStream {
    static Logger log = LoggerFactory.getLogger(SequentialMultiStream.class);
    String sourceKey = "@source";
    int index = 0;

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public Data readNext() throws Exception {
        Data data = null;
        while (data == null && this.index < this.additionOrder.size()) {
            try {
                String current = (String)this.additionOrder.get(this.index);
                log.debug("Current stream is: {}", (Object)current);
                Stream currentStream = (Stream)this.streams.get(current);
                data = currentStream.read();
                if (data != null) {
                    data.put((Object)this.sourceKey, (Object)current);
                    log.debug("   returning data {}", (Object)data);
                    return data;
                }
                log.debug("Stream {} ended, switching to next stream", (Object)current);
                ++this.index;
                if (this.index < this.additionOrder.size()) continue;
                log.debug("No more streams to read from!");
                return null;
            }
            catch (Exception e) {
                log.error("Error: {}", (Object)e.getMessage());
                if (!log.isTraceEnabled()) continue;
                e.printStackTrace();
            }
        }
        log.debug("No more streams to read from - all seem to have reached their end.");
        return null;
    }
}

