/*
 * Decompiled with CFR 0.152.
 */
package stream.io.multi;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.AbstractStream;
import stream.io.SourceURL;
import stream.io.Stream;
import stream.io.multi.AbstractMultiStream;

public class DirectoryMultiStream
extends AbstractMultiStream {
    static Logger log = LoggerFactory.getLogger(DirectoryMultiStream.class);
    private File dir;
    private static BlockingQueue<String> files;
    private String suffix;
    private static AtomicBoolean filesAreRead;
    private String[] order;
    private AbstractStream stream;

    public DirectoryMultiStream(SourceURL url) {
        super(url);
        if (filesAreRead == null) {
            filesAreRead = new AtomicBoolean(false);
        }
        if (files == null) {
            files = new LinkedBlockingQueue<String>();
        }
    }

    public DirectoryMultiStream(InputStream in) {
        super(in);
    }

    public DirectoryMultiStream() {
    }

    public String[] getOrder() {
        return this.order;
    }

    public void setOrder(String[] order) {
        this.order = order;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void init() throws Exception {
        block6: {
            if (filesAreRead.getAndSet(true)) break block6;
            if (this.streams.size() != 1) {
                throw new IllegalArgumentException("Only one inner Stream is supported!");
            }
            this.dir = new File(this.url.getFile());
            if (!(this.dir.isDirectory() || this.url.getProtocol().equals("file") && this.url.getProtocol().equals("classpath"))) {
                throw new IllegalArgumentException("Given URL " + this.url.getPath() + "is no local directory");
            }
            String[] f = null;
            f = this.suffix != null && !this.suffix.isEmpty() ? this.dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.startsWith(".") && name.endsWith(DirectoryMultiStream.this.suffix);
                }
            }) : this.dir.list();
            List<String> fil = Arrays.asList(f);
            if (this.order != null) {
                for (String file : this.order) {
                    if (!fil.contains(file)) continue;
                    files.add(file);
                }
            } else {
                for (String file : f) {
                    files.add(file);
                }
            }
        }
    }

    private SourceURL createUrl(String fileName) throws Exception {
        String urlString = this.url.getProtocol() + ":" + this.url.getPath() + "/" + fileName;
        return new SourceURL(urlString);
    }

    public Data readNext() throws Exception {
        Data data;
        SourceURL surl;
        if (this.stream == null) {
            String f = files.poll(2L, TimeUnit.SECONDS);
            if (f == null) {
                return null;
            }
            Stream tmpStream = (Stream)this.streams.get(this.additionOrder.get(0));
            if (!(tmpStream instanceof AbstractStream)) {
                throw new IllegalArgumentException("Only Subclasses of AbstractStream are supported!");
            }
            this.stream = (AbstractStream)tmpStream;
            surl = this.createUrl(f);
            this.stream.setUrl(surl);
            log.info("Set Url:{}", (Object)surl.toString());
            this.stream.init();
        }
        if ((data = this.stream.read()) != null) {
            return data;
        }
        String f = (String)files.poll();
        if (f == null) {
            return null;
        }
        this.stream.close();
        surl = null;
        surl = this.createUrl(f);
        this.stream.setUrl(surl);
        this.stream.init();
        data = this.stream.read();
        return data;
    }
}

