/*
 * Decompiled with CFR 0.152.
 */
package stream.io.active;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.io.AbstractStream;
import stream.io.Stream;
import stream.io.active.ActiveStream;

public class SimpleActiveStream
extends AbstractStream
implements ActiveStream {
    protected Logger log = LoggerFactory.getLogger(SimpleActiveStream.class);
    protected final LinkedBlockingQueue<Data> queue;
    protected Stream stream;
    protected StreamActivator activator;
    protected ExecutorService pool;

    public SimpleActiveStream(Stream stream, ExecutorService pool) {
        this.stream = stream;
        this.queue = new LinkedBlockingQueue(100);
        this.pool = pool;
    }

    public void activate() throws Exception {
        this.activator = new StreamActivator();
        this.pool.execute(this.activator);
    }

    public void init() throws Exception {
        this.stream.init();
    }

    public Data readNext() throws Exception {
        return this.queue.poll();
    }

    public void close() throws Exception {
        this.pool.shutdownNow();
        super.close();
    }

    private class StreamActivator
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        SimpleActiveStream.this.queue.put(SimpleActiveStream.this.stream.read());
                    }
                }
                catch (InterruptedException e) {
                    SimpleActiveStream.this.log.error("Interrupted while reading stream: {}", (Object)e.getMessage());
                    if (!SimpleActiveStream.this.log.isDebugEnabled()) continue;
                    e.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    SimpleActiveStream.this.log.error("Error while reading stream: {}", (Object)e.getMessage());
                    if (!SimpleActiveStream.this.log.isDebugEnabled()) continue;
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

