/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import stream.Data;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.io.SourceURL;
import stream.util.parser.TimeParser;

public class TimeStream
extends AbstractStream {
    String key = "@timestamp";
    String interval = "";
    Long gap = -1L;
    long last = 0L;

    public TimeStream() {
        super((SourceURL)null);
    }

    public String getInterval() {
        return this.interval;
    }

    @Parameter(description="The time gap/rate at which this stream should provide items.", required=true)
    public void setInterval(String interval) {
        this.interval = interval;
        try {
            this.gap = TimeParser.parseTime((String)interval);
        }
        catch (Exception e) {
            this.gap = -1L;
            throw new RuntimeException("Invalid time string '" + interval + "': " + e.getMessage());
        }
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The name of the attribute that should hold the timestamp, defaults to `@timestamp`", required=false)
    public void setKey(String key) {
        this.key = key;
    }

    public Data readNext() throws Exception {
        Data instance = DataFactory.create();
        Long timestamp = System.currentTimeMillis();
        if (this.gap > 0L) {
            long t = timestamp - timestamp % this.gap;
            long t2 = this.gap - (timestamp - t);
            try {
                if (t2 > 0L) {
                    Thread.sleep(t2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            timestamp = System.currentTimeMillis();
        }
        this.last = timestamp;
        instance.put((Object)this.key, (Object)timestamp);
        return instance;
    }
}

