/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.io.AbstractLineStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class SvmLightStream
extends AbstractLineStream {
    static Logger log = LoggerFactory.getLogger(SvmLightStream.class);
    long lineNumber = 0L;
    boolean addSparseVector = true;
    String sparseKey = null;

    public SvmLightStream(SourceURL url) throws Exception {
        super(url);
    }

    public SvmLightStream(SourceURL url, String sparseVectorKey) throws Exception {
        this(url);
        this.setSparseKey(sparseVectorKey);
    }

    public SvmLightStream(InputStream in) throws Exception {
        super(in);
    }

    public String getSparseKey() {
        return this.sparseKey;
    }

    public void setSparseKey(String sparseKey) {
        this.sparseKey = sparseKey == null ? null : sparseKey;
    }

    public Data readNext() throws Exception {
        Data item = DataFactory.create();
        if (this.limit > 0L && this.lineNumber > this.limit) {
            return null;
        }
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        log.debug("line[{}]: {}", (Object)this.lineNumber, (Object)line);
        while (line != null && !line.matches("^(-|\\+)?\\d(\\.\\d+)?\\s.*")) {
            line = this.readLine();
        }
        if (line == null) {
            return null;
        }
        ++this.lineNumber;
        Data datum = SvmLightStream.parseLine(item, line);
        return datum;
    }

    public static Data parseLine(Data item, String line, String sparseKey) throws Exception {
        int info = line.indexOf("#");
        if (info > 0) {
            line = line.substring(0, info);
        }
        String[] token = line.split("\\s+");
        item.put((Object)"@label", (Object)new Double(token[0]));
        for (int i = 1; i < token.length; ++i) {
            String[] iv = token[i].split(":");
            if (iv.length != 2) {
                log.error("Failed to split token '{}' in line: ", (Object)token[i], (Object)line);
                return null;
            }
            item.put((Object)iv[0], (Object)new Double(iv[1]));
        }
        return item;
    }

    public static Data parseLine(Data item, String line) throws Exception {
        return SvmLightStream.parseLine(item, line, null);
    }

    @Override
    public void close() {
        block2: {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                log.error("Failed to properly close reader: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }
}

