/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.InputStream;
import java.io.Serializable;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.io.AbstractLineStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class JSONStream
extends AbstractLineStream {
    private final Logger log = LoggerFactory.getLogger(JSONStream.class);
    private final JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);

    public JSONStream(InputStream in) throws Exception {
        super(in);
    }

    public JSONStream(SourceURL url) throws Exception {
        super(url);
    }

    public JSONStream() throws Exception {
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    public Data readNext() throws Exception {
        Data instance = DataFactory.create();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        while (line != null) {
            try {
                this.log.debug("line: {}", (Object)line);
                this.log.debug("Parsing item from {}", (Object)line);
                JSONObject object = (JSONObject)this.parser.parse(line, JSONObject.class);
                if (object != null) {
                    for (String key : object.keySet()) {
                        Object val = object.get((Object)key);
                        if (val == null) continue;
                        if (val instanceof Serializable) {
                            instance.put((Object)key, (Object)((Serializable)val));
                            continue;
                        }
                        instance.put((Object)key, (Object)val.toString());
                    }
                } else {
                    this.log.debug("Failed to parse item, object = {}", (Object)object);
                }
                this.log.debug("returning instance: {}", (Object)instance);
                return instance;
            }
            catch (Exception e) {
                this.log.error("Failed to parse line: {}", (Object)line);
                e.printStackTrace();
                line = this.readLine();
            }
        }
        return null;
    }
}

