/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Description;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources")
public class DirectoryStream
extends AbstractStream {
    Logger log = LoggerFactory.getLogger(DirectoryStream.class);
    private File dir;
    private static String[] files;
    private String dirPath;
    private static AtomicInteger counter;
    private static AtomicBoolean filesAreRead;

    public DirectoryStream(SourceURL url) throws Exception {
        super(url);
        if (filesAreRead == null) {
            filesAreRead = new AtomicBoolean(true);
        }
    }

    public void init() throws Exception {
        if (filesAreRead.getAndSet(false)) {
            this.log.debug("Initializing directory stream with URL '{}'", (Object)this.url.toString());
            this.log.debug("   file path of URL is: {}", (Object)this.url.getFile());
            this.dir = new File(this.url.getFile());
            if (!this.dir.isDirectory()) {
                throw new IllegalArgumentException("Directory not found");
            }
            this.dirPath = this.dir.getAbsolutePath();
            files = this.dir.list();
            counter = new AtomicInteger(0);
        }
    }

    public Data readNext() throws Exception {
        Data data = DataFactory.create();
        int c = counter.getAndIncrement();
        if (c < files.length) {
            data.put((Object)"@url", (Object)new URL("file:" + this.dirPath + System.getProperty("file.separator") + files[c]));
            data.put((Object)"@directory", (Object)this.dirPath);
            data.put((Object)"@filename", (Object)files[c]);
            return data;
        }
        filesAreRead.getAndSet(true);
        return null;
    }
}

