/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.ProcessContext;
import stream.expressions.MacroExpander;
import stream.io.AbstractWriter;
import stream.util.Time;

public class BinaryWriter
extends AbstractWriter {
    static Logger log = LoggerFactory.getLogger(BinaryWriter.class);
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    final SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");
    final SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
    File file;
    File current;
    OutputStream os;
    long bytesWritten = 0L;
    Time rotate = new Time(Long.valueOf(60000L));

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.current = this.file;
        if (!this.file.getParentFile().isDirectory()) {
            this.file.getParentFile().mkdirs();
        }
        this.os = new FileOutputStream(this.file);
    }

    @Override
    public void write(Data input) throws Exception {
        Set<String> ks = this.selectedKeys(input);
        if (!ks.isEmpty()) {
            for (String key : ks) {
                Serializable value = (Serializable)input.get((Object)key);
                if (value == null || !value.getClass().isArray() || value.getClass().getComponentType() != Byte.TYPE) continue;
                try {
                    byte[] data = (byte[])value;
                    long ts = System.currentTimeMillis();
                    Date now = new Date(ts);
                    input.put((Object)"timestamp", (Object)ts);
                    input.put((Object)"datetime", (Object)this.fmt.format(now));
                    input.put((Object)"time", (Object)this.timeFormat.format(now));
                    input.put((Object)"date", (Object)this.dateFormat.format(now));
                    File df = new File(MacroExpander.expand((String)this.file.getAbsolutePath(), (Map)input));
                    if (!df.getCanonicalPath().endsWith(this.current.getCanonicalPath())) {
                        log.info("Closing file {}", (Object)this.current.getAbsoluteFile());
                        this.os.flush();
                        this.os.close();
                        if (!df.getParentFile().isDirectory()) {
                            df.getParentFile().mkdirs();
                        }
                        this.os = new FileOutputStream(df);
                        this.current = df;
                    }
                    this.os.write(data);
                    this.os.flush();
                    this.bytesWritten += (long)data.length;
                    input.put((Object)"file", (Object)("file:" + df.getAbsolutePath()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

