/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import stream.io.AbstractStream;
import stream.io.SourceURL;

public abstract class AbstractLineStream
extends AbstractStream {
    protected Map<String, Class<?>> attributes;
    protected BufferedReader reader;
    protected String encoding;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public AbstractLineStream(SourceURL url) {
        super(url);
    }

    public AbstractLineStream(InputStream in) {
        super(in);
    }

    public AbstractLineStream() throws Exception {
    }

    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        super.close();
    }

    public void init() throws Exception {
        super.init();
        this.attributes = new LinkedHashMap();
        this.reader = this.encoding != null ? new BufferedReader(new InputStreamReader(this.getInputStream(), this.encoding)) : new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    public String readLine() throws Exception {
        return this.reader.readLine();
    }
}

