/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import java.util.LinkedHashMap;
import java.util.Map;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.generator.SFMT19937;
import stream.io.AbstractStream;
import stream.io.SourceURL;

@Description(group="Data Stream.Sources.Synthetic")
public class RandomIntegerStream
extends AbstractStream {
    Map<String, Object> store = new LinkedHashMap<String, Object>();
    Map<String, Class<?>> attributes = new LinkedHashMap();
    SFMT19937[] random = null;
    String[] keys = new String[]{"att1"};

    public RandomIntegerStream() {
        super((SourceURL)null);
    }

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(required=false, description="The attribute names to create (comma separated)")
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public Data readNext() throws Exception {
        Data data = DataFactory.create();
        if (this.keys == null) {
            this.keys = new String[]{"x1"};
        }
        if (this.random == null) {
            this.random = new SFMT19937[this.keys.length];
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.random[i] == null) {
                this.random[i] = new SFMT19937((long)i * 1000L);
            }
            data.put((Object)this.keys[i], (Object)this.next(this.random[i]));
        }
        return data;
    }

    public Integer next(SFMT19937 rnd) {
        return rnd.next();
    }

    public Object get(String key) {
        return this.store.get(key);
    }

    public Object get(String key, Object init) {
        if (this.store.get(key) == null) {
            this.store.put(key, init);
            return init;
        }
        return this.store.get(key);
    }

    public void set(String key, Object val) {
        this.store.put(key, val);
    }

    public Map<String, Class<?>> getAttributes() {
        return this.attributes;
    }
}

